/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.api.game.stats.StatisticMap;
import xyz.nucleoid.plasmid.api.util.PlayerRef;

public class GameStatisticBundle {
    private static final String NAMESPACE_ERROR_MESSAGE = "Bundle namespaces can only contain [a-zA-Z0-9_]";
    public static final Codec<String> NAMESPACE_CODEC = Codec.STRING.comapFlatMap(string -> {
        for (char c : string.toCharArray()) {
            if (GameStatisticBundle.validateNamespaceChar(c)) continue;
            return DataResult.error(() -> NAMESPACE_ERROR_MESSAGE);
        }
        return DataResult.success((Object)string);
    }, Function.identity());
    private final Object2ObjectMap<UUID, StatisticMap> players = new Object2ObjectOpenHashMap();
    private final StatisticMap global = new StatisticMap();

    public StatisticMap forPlayer(PlayerRef player) {
        return this.forPlayer(player.id());
    }

    public StatisticMap forPlayer(class_3222 player) {
        return this.forPlayer(player.method_5667());
    }

    public StatisticMap forPlayer(UUID uuid) {
        return (StatisticMap)this.players.computeIfAbsent((Object)uuid, __ -> new StatisticMap());
    }

    public StatisticMap global() {
        return this.global;
    }

    public boolean isEmpty() {
        return this.global.isEmpty() && (this.players.isEmpty() || this.players.values().stream().allMatch(StatisticMap::isEmpty));
    }

    public JsonObject encode() {
        JsonObject obj = new JsonObject();
        JsonObject players = new JsonObject();
        for (Map.Entry entry : this.players.entrySet()) {
            if (((StatisticMap)entry.getValue()).isEmpty()) continue;
            players.add(((UUID)entry.getKey()).toString(), (JsonElement)((StatisticMap)entry.getValue()).encode());
        }
        obj.add("players", (JsonElement)players);
        if (!this.global.isEmpty()) {
            obj.add("global", (JsonElement)this.global.encode());
        }
        return obj;
    }

    public static void validateNamespace(String namespace) {
        for (char c : namespace.toCharArray()) {
            if (GameStatisticBundle.validateNamespaceChar(c)) continue;
            throw new IllegalArgumentException(NAMESPACE_ERROR_MESSAGE);
        }
    }

    public static String getTranslationKey(String namespace) {
        return "statistic.bundle." + namespace;
    }

    private static boolean validateNamespaceChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }
}

