/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.stats;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

public record StatisticKey<T extends Number>(class_2960 id, ValueType valueType, boolean hidden) {
    public StatisticKey {
        StatisticKey.validateKeyId(id);
    }

    public JsonObject encodeValueUnchecked(Number value) {
        return this.encodeValue(value);
    }

    public JsonObject encodeValue(T value) {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.valueType.method_15434());
        obj.addProperty("value", value);
        obj.addProperty("hidden", Boolean.valueOf(this.hidden));
        return obj;
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"statistic", (class_2960)this.id);
    }

    public static StatisticKey<Integer> intKey(class_2960 id) {
        return new StatisticKey<Integer>(id, ValueType.INT, false);
    }

    public static StatisticKey<Float> floatKey(class_2960 id) {
        return new StatisticKey<Float>(id, ValueType.FLOAT, false);
    }

    public static StatisticKey<Double> doubleKey(class_2960 id) {
        return new StatisticKey<Double>(id, ValueType.FLOAT, false);
    }

    public StatisticKey<T> hidden(boolean hidden) {
        return new StatisticKey<T>(this.id, this.valueType, hidden);
    }

    private static void validateKeyId(class_2960 id) {
        if (id.method_12836().contains(".") || id.method_12832().contains(".")) {
            throw new IllegalArgumentException("StatisticKey ids cannot contain '.'");
        }
    }

    public static enum ValueType implements class_3542
    {
        INT("int_total"),
        FLOAT("float_total");

        public static final Codec<ValueType> CODEC;
        private final String name;

        private ValueType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(ValueType::values);
        }
    }
}

