/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.map.template.processor;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10352;
import net.minecraft.class_176;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import xyz.nucleoid.map_templates.MapTemplate;
import xyz.nucleoid.plasmid.api.game.GameOpenException;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeam;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamList;
import xyz.nucleoid.plasmid.api.map.MapLoadContexts;
import xyz.nucleoid.plasmid.api.map.template.processor.MapTemplateProcessor;
import xyz.nucleoid.plasmid.api.map.template.processor.ReplaceBlockEntitiesTemplateProcessor;
import xyz.nucleoid.plasmid.api.map.template.processor.ReplaceBlocksTemplateProcessor;
import xyz.nucleoid.plasmid.api.util.ColoredBlocks;
import xyz.nucleoid.plasmid.api.util.ColoredItems;

public record TeamColorMapTemplateProcessor(List<class_1767> baseColors) implements MapTemplateProcessor
{
    public static final MapCodec<TeamColorMapTemplateProcessor> CODEC = class_1767.field_41600.listOf().fieldOf("base_colors").xmap(TeamColorMapTemplateProcessor::new, TeamColorMapTemplateProcessor::baseColors);
    private static final class_176 CONTEXT_TYPE = new class_176.class_177().method_781(MapLoadContexts.TEAM_LIST).method_782();

    @Override
    public MapCodec<? extends MapTemplateProcessor> getCodec() {
        return CODEC;
    }

    @Override
    public void processTemplate(MapTemplate template, class_10352.class_10353 parameters) {
        parameters.method_64971(CONTEXT_TYPE);
        List<GameTeam> teamList = ((GameTeamList)parameters.method_64969(MapLoadContexts.TEAM_LIST)).list();
        if (teamList.size() > this.baseColors.size()) {
            throw new GameOpenException((class_2561)class_2561.method_43470((String)"Not enough base colors provided for the number of teams."));
        }
        HashMap<class_2248, class_2248> blockMap = new HashMap<class_2248, class_2248>();
        HashMap<String, String> blockEntityReplace = new HashMap<String, String>();
        for (int i = 0; i < teamList.size(); ++i) {
            class_1767 baseColor = this.baseColors.get(i);
            class_1767 teamColor = teamList.get(i).config().blockDyeColor();
            blockMap.put(ColoredBlocks.wool(baseColor), ColoredBlocks.wool(teamColor));
            blockMap.put(ColoredBlocks.carpet(baseColor), ColoredBlocks.carpet(teamColor));
            blockMap.put(ColoredBlocks.terracotta(baseColor), ColoredBlocks.terracotta(teamColor));
            blockMap.put(ColoredBlocks.glazedTerracotta(baseColor), ColoredBlocks.glazedTerracotta(teamColor));
            blockMap.put(ColoredBlocks.concrete(baseColor), ColoredBlocks.concrete(teamColor));
            blockMap.put(ColoredBlocks.concretePowder(baseColor), ColoredBlocks.concretePowder(teamColor));
            blockMap.put(ColoredBlocks.glass(baseColor), ColoredBlocks.glass(teamColor));
            blockMap.put(ColoredBlocks.glassPane(baseColor), ColoredBlocks.glassPane(teamColor));
            blockMap.put(ColoredBlocks.bed(baseColor), ColoredBlocks.bed(teamColor));
            blockMap.put(ColoredBlocks.shulkerBox(baseColor), ColoredBlocks.shulkerBox(teamColor));
            blockMap.put(ColoredBlocks.candle(baseColor), ColoredBlocks.candle(teamColor));
            blockMap.put(ColoredBlocks.candleCake(baseColor), ColoredBlocks.candleCake(teamColor));
            blockEntityReplace.put(class_7923.field_41178.method_10221((Object)ColoredItems.dye(baseColor)).toString(), class_7923.field_41178.method_10221((Object)ColoredItems.dye(teamColor)).toString());
            blockEntityReplace.put(class_7923.field_41178.method_10221((Object)ColoredItems.bundle(baseColor)).toString(), class_7923.field_41178.method_10221((Object)ColoredItems.bundle(teamColor)).toString());
            blockEntityReplace.put(class_7923.field_41178.method_10221((Object)ColoredItems.harness(baseColor)).toString(), class_7923.field_41178.method_10221((Object)ColoredItems.harness(teamColor)).toString());
        }
        new ReplaceBlocksTemplateProcessor(blockMap).processTemplate(template, parameters);
        for (Map.Entry<class_2248, class_2248> entry : blockMap.entrySet()) {
            blockEntityReplace.put(class_7923.field_41175.method_10221((Object)entry.getKey()).toString(), class_7923.field_41175.method_10221((Object)entry.getValue()).toString());
        }
        new ReplaceBlockEntitiesTemplateProcessor(blockEntityReplace).processTemplate(template, parameters);
    }
}

