/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.shop;

import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.shop.Cost;
import xyz.nucleoid.plasmid.api.util.ItemStackBuilder;

public final class ShopEntry
implements GuiElementInterface {
    private final ItemStackBuilder defaultIcon;
    private @Nullable BiFunction<class_3222, ShopEntry, @NotNull Cost> cost;
    private BiFunction<class_3222, ShopEntry, class_1799> icon;
    private BiPredicate<class_3222, ShopEntry> canBuy;
    private BiPredicate<class_3222, ShopEntry> preBuyCheck = (serverPlayerEntity, entry) -> true;
    private Consumer<class_3222> buyAction;

    private ShopEntry(class_1799 defaultIcon) {
        this.defaultIcon = ItemStackBuilder.of(defaultIcon);
        this.icon = this::defaultIconBuilder;
    }

    private class_1799 defaultIconBuilder(class_3222 player, ShopEntry entry) {
        class_1799 icon = this.defaultIcon.build();
        boolean canBuy = this.canBuy.test(player, entry);
        class_2583 style = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(canBuy ? class_124.field_1078 : class_124.field_1061);
        class_5250 name = icon.method_7964().method_27661().method_10862(style);
        if (this.cost != null) {
            Cost cost = this.cost.apply(player, entry);
            class_2561 costText = cost.getDisplay();
            costText = class_2561.method_43470((String)" (").method_10852(costText).method_27693(")").method_10862(costText.method_10866());
            name.method_10852(costText);
        }
        icon.method_57379(class_9334.field_49631, (Object)name);
        return icon;
    }

    public static ShopEntry ofIcon(class_1799 icon) {
        return new ShopEntry(icon);
    }

    public static ShopEntry ofIcon(class_1935 icon) {
        return new ShopEntry(new class_1799(icon));
    }

    public static ShopEntry ofIcon(BiFunction<class_3222, ShopEntry, class_1799> iconBuilder) {
        ShopEntry entry = new ShopEntry(class_1799.field_8037);
        entry.icon = iconBuilder;
        return entry;
    }

    public static ShopEntry buyItem(class_1799 stack) {
        class_1799 icon = stack.method_7972();
        class_5250 count = class_2561.method_43470((String)(stack.method_7947() + "x "));
        class_5250 name = icon.method_7964().method_27661().method_27692(class_124.field_1067);
        icon.method_57379(class_9334.field_49631, (Object)count.method_10852((class_2561)name).method_27694(GuiHelpers.STYLE_CLEARER));
        return new ShopEntry(icon).onBuy(player -> player.method_31548().method_7398(stack.method_7972()));
    }

    public static ShopEntry buyItem(class_1799 stack, Cost cost) {
        class_1799 icon = stack.method_7972();
        class_5250 count = class_2561.method_43470((String)(stack.method_7947() + "x "));
        class_5250 name = icon.method_7964().method_27661().method_27692(class_124.field_1067);
        icon.method_57379(class_9334.field_49631, (Object)count.method_10852((class_2561)name).method_27694(GuiHelpers.STYLE_CLEARER));
        return new ShopEntry(icon).onBuy(player -> player.method_31548().method_7398(stack.method_7972())).withCost(cost);
    }

    public ShopEntry onBuy(Consumer<class_3222> action) {
        this.buyAction = action;
        return this;
    }

    public ShopEntry onBuyCheck(BiPredicate<class_3222, ShopEntry> buyCheck) {
        this.preBuyCheck = buyCheck;
        return this;
    }

    public ShopEntry withCost(Cost cost) {
        this.canBuy = (player, entry) -> cost.canBuy((class_3222)player);
        this.preBuyCheck = (player, entry) -> cost.takeItems((class_3222)player);
        this.cost = (player, entry) -> cost;
        return this;
    }

    public ShopEntry withCost(BiFunction<class_3222, ShopEntry, Cost> cost) {
        this.canBuy = (player, entry) -> ((Cost)cost.apply((class_3222)player, (ShopEntry)entry)).canBuy((class_3222)player);
        this.preBuyCheck = (player, entry) -> ((Cost)cost.apply((class_3222)player, (ShopEntry)entry)).takeItems((class_3222)player);
        this.cost = cost;
        return this;
    }

    public ShopEntry noCost() {
        this.canBuy = (player, entry) -> true;
        this.preBuyCheck = (player, entry) -> true;
        this.cost = null;
        return this;
    }

    public ShopEntry withName(class_2561 name) {
        this.defaultIcon.setName(name);
        return this;
    }

    public ShopEntry addLore(class_2561 lore) {
        this.defaultIcon.addLore(lore);
        return this;
    }

    public class_1799 getItemStack() {
        return this.defaultIcon.build();
    }

    @Nullable
    public Cost getCost(class_3222 player) {
        return this.cost != null ? this.cost.apply(player, this) : null;
    }

    public boolean canBuy(class_3222 player) {
        return this.canBuy.test(player, this);
    }

    public boolean runPreBuyCheck(class_3222 player) {
        return this.preBuyCheck.test(player, this);
    }

    public void runBuyAction(class_3222 player) {
        this.buyAction.accept(player);
    }

    @ApiStatus.Internal
    public class_1799 getItemStackForDisplay(GuiInterface gui) {
        return this.icon.apply(gui.getPlayer(), this);
    }

    @ApiStatus.Internal
    public GuiElementInterface.ClickCallback getGuiCallback() {
        return (x, y, z, gui) -> {
            class_3414 sound;
            if (this.preBuyCheck.test(gui.getPlayer(), this)) {
                if (this.buyAction != null) {
                    this.buyAction.accept(gui.getPlayer());
                }
                sound = class_3417.field_14627;
            } else {
                sound = class_3417.field_15008;
            }
            gui.getPlayer().method_17356(sound, class_3419.field_15250, 1.0f, 1.0f);
        };
    }
}

