/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.util;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;

public final class BlockTraversal {
    private Connectivity connectivity = Connectivity.SIX;
    private Order order = Order.BREADTH_FIRST;

    private BlockTraversal() {
    }

    public static BlockTraversal create() {
        return new BlockTraversal();
    }

    public BlockTraversal connectivity(Connectivity connectivity) {
        this.connectivity = connectivity;
        return this;
    }

    public BlockTraversal order(Order order) {
        this.order = order;
        return this;
    }

    public void accept(class_2338 origin, Visitor visitor) {
        State state = new State(this.order);
        state.enqueue(origin, origin, 0);
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 fromPos = new class_2338.class_2339();
        class_2382[] offsets = this.connectivity.offsets;
        while (!state.isComplete()) {
            pos.method_16363(state.dequeuePos());
            fromPos.method_16363(state.dequeueFromPos());
            int depth = state.dequeueDepth();
            if (!state.tryVisit((class_2338)pos) || visitor.visit((class_2338)pos, (class_2338)fromPos, depth) != Result.CONTINUE) continue;
            int nextDepth = depth + 1;
            fromPos.method_10101((class_2382)pos);
            for (class_2382 offset : offsets) {
                pos.method_25504((class_2382)fromPos, offset.method_10263(), offset.method_10264(), offset.method_10260());
                state.enqueue((class_2338)pos, (class_2338)fromPos, nextDepth);
            }
        }
    }

    public static final class Connectivity {
        public static final Connectivity SIX = Connectivity.create(Connectivity::generateSix);
        public static final Connectivity EIGHTEEN = Connectivity.create(Connectivity::generateEighteen);
        public static final Connectivity TWENTY_SIX = Connectivity.create(Connectivity::generateTwentySix);
        private static final Connectivity FOUR_X = Connectivity.create(consumer -> Connectivity.generateFour(class_2350.class_2351.field_11048, consumer));
        private static final Connectivity FOUR_Y = Connectivity.create(consumer -> Connectivity.generateFour(class_2350.class_2351.field_11052, consumer));
        private static final Connectivity FOUR_Z = Connectivity.create(consumer -> Connectivity.generateFour(class_2350.class_2351.field_11051, consumer));
        private static final Connectivity EIGHT_X = Connectivity.create(consumer -> Connectivity.generateEight(class_2350.class_2351.field_11048, consumer));
        private static final Connectivity EIGHT_Y = Connectivity.create(consumer -> Connectivity.generateEight(class_2350.class_2351.field_11052, consumer));
        private static final Connectivity EIGHT_Z = Connectivity.create(consumer -> Connectivity.generateEight(class_2350.class_2351.field_11051, consumer));
        final class_2382[] offsets;

        Connectivity(class_2382[] offsets) {
            this.offsets = offsets;
        }

        public static Connectivity four(class_2350.class_2351 orthogonalAxis) {
            return switch (orthogonalAxis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> FOUR_X;
                case class_2350.class_2351.field_11052 -> FOUR_Y;
                case class_2350.class_2351.field_11051 -> FOUR_Z;
            };
        }

        public static Connectivity eight(class_2350.class_2351 orthogonalAxis) {
            return switch (orthogonalAxis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> EIGHT_X;
                case class_2350.class_2351.field_11052 -> EIGHT_Y;
                case class_2350.class_2351.field_11051 -> EIGHT_Z;
            };
        }

        static Connectivity create(Consumer<Consumer<class_2382>> generator) {
            ArrayList offsets = new ArrayList();
            generator.accept(offsets::add);
            return new Connectivity(offsets.toArray(new class_2382[0]));
        }

        private static void generateSix(Consumer<class_2382> consumer) {
            for (class_2350 direction : class_2350.values()) {
                consumer.accept(direction.method_62675());
            }
        }

        private static void generateEighteen(Consumer<class_2382> consumer) {
            Connectivity.generateSix(consumer);
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    consumer.accept((class_2382)new class_2338(x, y, 0));
                    consumer.accept((class_2382)new class_2338(0, x, y));
                    consumer.accept((class_2382)new class_2338(y, 0, x));
                }
            }
        }

        private static void generateTwentySix(Consumer<class_2382> consumer) {
            Connectivity.generateEighteen(consumer);
            for (int z = -1; z <= 1; z += 2) {
                for (int x = -1; x <= 1; x += 2) {
                    for (int y = -1; y <= 1; y += 2) {
                        consumer.accept((class_2382)new class_2338(x, y, z));
                    }
                }
            }
        }

        private static void generateFour(class_2350.class_2351 orthogonalAxis, Consumer<class_2382> consumer) {
            for (class_2350 direction : class_2350.values()) {
                if (direction.method_10166() == orthogonalAxis) continue;
                consumer.accept(direction.method_62675());
            }
        }

        private static void generateEight(class_2350.class_2351 orthogonalAxis, Consumer<class_2382> consumer) {
            Connectivity.generateFour(orthogonalAxis, consumer);
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    consumer.accept((class_2382)(switch (orthogonalAxis) {
                        default -> throw new MatchException(null, null);
                        case class_2350.class_2351.field_11048 -> new class_2338(0, x, y);
                        case class_2350.class_2351.field_11052 -> new class_2338(y, 0, x);
                        case class_2350.class_2351.field_11051 -> new class_2338(x, y, 0);
                    }));
                }
            }
        }
    }

    public static enum Order {
        BREADTH_FIRST,
        DEPTH_FIRST;

    }

    static final class State {
        private final Order order;
        private final LongSet visited = new LongOpenHashSet();
        private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        private final LongArrayFIFOQueue fromQueue = new LongArrayFIFOQueue();
        private final ShortArrayFIFOQueue depthQueue = new ShortArrayFIFOQueue();

        State(Order order) {
            this.order = order;
        }

        boolean tryVisit(class_2338 pos) {
            return this.visited.add(pos.method_10063());
        }

        void enqueue(class_2338 pos, class_2338 from, int depth) {
            this.queue.enqueue(pos.method_10063());
            this.fromQueue.enqueue(from.method_10063());
            this.depthQueue.enqueue((short)depth);
        }

        long dequeuePos() {
            return this.dequeuePos(this.queue);
        }

        long dequeueFromPos() {
            return this.dequeuePos(this.fromQueue);
        }

        long dequeuePos(LongArrayFIFOQueue queue) {
            return this.order == Order.BREADTH_FIRST ? queue.dequeueLong() : queue.dequeueLastLong();
        }

        int dequeueDepth() {
            return this.order == Order.BREADTH_FIRST ? this.depthQueue.dequeueShort() : this.depthQueue.dequeueLastShort();
        }

        boolean isComplete() {
            return this.queue.isEmpty();
        }
    }

    public static interface Visitor {
        public Result visit(class_2338 var1, class_2338 var2, int var3);
    }

    public static enum Result {
        CONTINUE,
        TERMINATE;

    }
}

