/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl;

import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import com.sun.net.httpserver.HttpServer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameTypes;
import xyz.nucleoid.plasmid.api.game.common.team.provider.TeamListProviderTypes;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.map.template.processor.MapTemplateProcessorTypes;
import xyz.nucleoid.plasmid.api.portal.GamePortalConfigs;
import xyz.nucleoid.plasmid.api.portal.menu.MenuEntryConfigs;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;
import xyz.nucleoid.plasmid.impl.PlasmidWebServer;
import xyz.nucleoid.plasmid.impl.command.ChatCommand;
import xyz.nucleoid.plasmid.impl.command.GameCommand;
import xyz.nucleoid.plasmid.impl.command.GamePortalCommand;
import xyz.nucleoid.plasmid.impl.command.GameTestCommand;
import xyz.nucleoid.plasmid.impl.command.ShoutCommand;
import xyz.nucleoid.plasmid.impl.compatibility.TrinketsCompatibility;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;
import xyz.nucleoid.plasmid.impl.portal.GamePortalManager;

public final class Plasmid
implements ModInitializer {
    public static final String ID = "plasmid";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"plasmid");
    private static HttpServer httpServer = null;

    public void onInitialize() {
        PlasmidRegistries.registerDynamicRegistries();
        Reflection.initialize((Class[])new Class[]{GamePortalConfigs.class});
        Reflection.initialize((Class[])new Class[]{MenuEntryConfigs.class});
        Reflection.initialize((Class[])new Class[]{GameTypes.class});
        Reflection.initialize((Class[])new Class[]{TeamListProviderTypes.class});
        Reflection.initialize((Class[])new Class[]{MapTemplateProcessorTypes.class});
        this.registerCallbacks();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketsCompatibility.onInitialize();
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    private void loadData(class_5455 registryManager, class_3300 manager) {
        GamePortalManager.INSTANCE.reload(registryManager, manager);
    }

    private void registerCallbacks() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            GameCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GamePortalCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ChatCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ShoutCommand.register((CommandDispatcher<class_2168>)dispatcher);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                GameTestCommand.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hit) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (entity instanceof GamePortalInterface) {
                    GamePortalInterface portalInterface = (GamePortalInterface)entity;
                    if (hand == class_1268.field_5808 && portalInterface.interactWithPortal(serverPlayer)) {
                        return class_1269.field_52422;
                    }
                }
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            ManagedGameSpace game = GameSpaceManagerImpl.get().byWorld((class_1937)world);
            if (game != null) {
                try {
                    game.getBehavior().propagatingInvoker(GameActivityEvents.TICK).onTick();
                }
                catch (Throwable t) {
                    game.closeWithError("An unexpected error occurred while ticking the game");
                }
            }
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> GamePortalManager.INSTANCE.tick());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            GameSpaceManagerImpl.openServer(server);
            GamePortalManager.INSTANCE.setup(server);
            this.loadData((class_5455)server.method_30611(), server.method_34864());
            PlasmidConfig.get().webServerConfig().ifPresent(config -> {
                httpServer = PlasmidWebServer.start(server, config);
            });
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            GameSpaceManagerImpl.startClosing();
            GamePortalManager.INSTANCE.close(server);
            if (httpServer != null) {
                httpServer.stop(0);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> GameSpaceManagerImpl.closeServer());
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> this.loadData((class_5455)server.method_30611(), (class_3300)resourceManager));
        if (Boolean.getBoolean("plasmid.debug_statistics")) {
            GameEvents.CLOSING.register((gameSpace, reason) -> gameSpace.getStatistics().visitAll((name, bundle) -> LOGGER.info(bundle.encode().toString())));
        }
    }
}

