/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameOpenException;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.MutablePlayerSet;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistryKeys;
import xyz.nucleoid.plasmid.api.util.Scheduler;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.command.argument.GameConfigArgument;
import xyz.nucleoid.plasmid.impl.command.argument.GameSpaceArgument;
import xyz.nucleoid.plasmid.impl.command.ui.GameJoinUi;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpacePlayers;

public final class GameCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SimpleCommandExceptionType NO_GAME_OPEN = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.plasmid.game.join.no_game_open"));
    public static final SimpleCommandExceptionType NOT_IN_GAME = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.plasmid.game.not_in_game"));
    public static final DynamicCommandExceptionType MALFORMED_CONFIG = new DynamicCommandExceptionType(error -> class_2561.method_54159((String)"text.plasmid.game.open.malformed_config", (Object[])new Object[]{error}));
    public static final DynamicCommandExceptionType PLAYER_NOT_IN_GAME = new DynamicCommandExceptionType(player -> class_2561.method_54159((String)"text.plasmid.game.locate.player_not_in_game", (Object[])new Object[]{player}));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"game").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"open").requires(Permissions.require((String)"plasmid.command.game.open", (int)2))).then(GameConfigArgument.argument("game_config").executes(GameCommand::openGame))).then(class_2170.method_9244((String)"game_config_nbt", (ArgumentType)class_2179.method_9284()).executes(GameCommand::openAnonymousGame)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"propose").requires(Permissions.require((String)"plasmid.command.game.propose", (int)2))).then(GameSpaceArgument.argument("game_space").executes(GameCommand::proposeGame))).executes(GameCommand::proposeCurrentGame))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(Permissions.require((String)"plasmid.command.game.start", (int)2))).executes(GameCommand::startGame))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(Permissions.require((String)"plasmid.command.game.stop", (int)2))).executes(GameCommand::stopGame)).then(class_2170.method_9247((String)"confirm").executes(GameCommand::stopGameConfirmed)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"kick").requires(Permissions.require((String)"plasmid.command.game.kick", (int)2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(GameCommand::kickPlayers)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"join").executes(ctx -> GameCommand.joinGame((CommandContext<class_2168>)ctx, JoinIntent.PLAY))).then(GameSpaceArgument.argument("game_space").executes(ctx -> GameCommand.joinQualifiedGame((CommandContext<class_2168>)ctx, JoinIntent.PLAY))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spectate").executes(ctx -> GameCommand.joinGame((CommandContext<class_2168>)ctx, JoinIntent.SPECTATE))).then(GameSpaceArgument.argument("game_space").executes(ctx -> GameCommand.joinQualifiedGame((CommandContext<class_2168>)ctx, JoinIntent.SPECTATE))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"joinall").requires(Permissions.require((String)"plasmid.command.game.joinall", (int)2))).executes(GameCommand::joinAllGame)).then(GameSpaceArgument.argument("game_space").executes(GameCommand::joinAllQualifiedGame)))).then(class_2170.method_9247((String)"locate").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(GameCommand::locatePlayer)))).then(class_2170.method_9247((String)"leave").executes(GameCommand::leaveGame))).then(class_2170.method_9247((String)"list").executes(GameCommand::listGames)));
    }

    private static int openGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        return GameCommand.openGame(context, false);
    }

    protected static int openGame(CommandContext<class_2168> context, boolean test) throws CommandSyntaxException {
        try {
            class_6880.class_6883<GameConfig<?>> game = GameConfigArgument.get(context, "game_config");
            return GameCommand.openGame(context, game, test);
        }
        catch (CommandSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while opening a game", (Throwable)e);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"text.plasmid.game.open.error").method_27692(class_124.field_1061), false);
            return 0;
        }
    }

    private static int openAnonymousGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        return GameCommand.openAnonymousGame(context, false);
    }

    protected static int openAnonymousGame(CommandContext<class_2168> context, boolean test) throws CommandSyntaxException {
        try {
            class_2487 configNbt = class_2179.method_9285(context, (String)"game_config_nbt");
            GameConfig game = (GameConfig)GameConfig.DIRECT_CODEC.parse((DynamicOps)((class_2168)context.getSource()).method_30497().method_57093((DynamicOps)class_2509.field_11560), (Object)configNbt).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)MALFORMED_CONFIG).create(arg_0));
            return GameCommand.openGame(context, class_6880.method_40223((Object)game), test);
        }
        catch (CommandSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while opening a game", (Throwable)e);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"text.plasmid.game.open.error").method_27692(class_124.field_1061), false);
            return 0;
        }
    }

    private static int openGame(CommandContext<class_2168> context, class_6880<GameConfig<?>> config, boolean test) {
        ManagedGameSpace currentGameSpace;
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_3222 player = source.method_44023();
        if (player != null && (currentGameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)player)) != null) {
            if (test) {
                currentGameSpace.close(GameCloseReason.CANCELED);
            } else {
                currentGameSpace.getPlayers().kick(player);
            }
        }
        GameSpaceManagerImpl.get().open(config).handleAsync((gameSpace, throwable) -> {
            if (throwable == null) {
                GameCommand.onOpenSuccess(source, gameSpace, player, test);
            } else {
                GameCommand.onOpenError(source, throwable);
            }
            return null;
        }, (Executor)server);
        return 1;
    }

    private static void onOpenSuccess(class_2168 source, GameSpace gameSpace, class_3222 player, boolean test) {
        class_3324 players = source.method_9211().method_3760();
        class_5250 message = test ? GameTexts.Broadcast.gameOpenedTesting(source, gameSpace) : GameTexts.Broadcast.gameOpened(source, gameSpace);
        players.method_43514((class_2561)message, false);
        if (test) {
            GameCommand.joinAllPlayersToGame(source, gameSpace);
            GameResult startResult = gameSpace.requestStart();
            if (!startResult.isOk()) {
                class_5250 error = startResult.errorCopy().method_27692(class_124.field_1061);
                gameSpace.getPlayers().sendMessage((class_2561)error);
            }
        } else if (player != null) {
            GameCommand.tryJoinGame(player, gameSpace, JoinIntent.PLAY);
        }
    }

    private static void onOpenError(class_2168 source, Throwable throwable) {
        Plasmid.LOGGER.error("Failed to start game", throwable);
        GameOpenException gameOpenException = GameOpenException.unwrap(throwable);
        class_5250 message = gameOpenException != null ? gameOpenException.getReason().method_27661() : GameTexts.Broadcast.gameOpenError();
        class_3324 players = source.method_9211().method_3760();
        players.method_43514((class_2561)message.method_27692(class_124.field_1061), false);
    }

    private static int proposeGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameSpace gameSpace = GameSpaceArgument.get(context, "game_space");
        return GameCommand.proposeGame((class_2168)context.getSource(), gameSpace);
    }

    private static int proposeCurrentGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)source.method_9207());
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }
        return GameCommand.proposeGame(source, gameSpace);
    }

    private static int proposeGame(class_2168 source, GameSpace gameSpace) {
        class_5250 message = GameTexts.Broadcast.propose(source, gameSpace);
        class_3324 playerManager = source.method_9211().method_3760();
        playerManager.method_43514((class_2561)message, false);
        return 1;
    }

    private static int joinGame(CommandContext<class_2168> context, JoinIntent intent) throws CommandSyntaxException {
        new GameJoinUi(((class_2168)context.getSource()).method_9207(), intent).open();
        return 1;
    }

    private static int joinQualifiedGame(CommandContext<class_2168> context, JoinIntent intent) throws CommandSyntaxException {
        GameSpace gameSpace = GameSpaceArgument.get(context, "game_space");
        GameCommand.tryJoinGame(((class_2168)context.getSource()).method_9207(), gameSpace, intent);
        return 1;
    }

    private static int joinAllGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameSpace gameSpace = null;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)player);
        }
        if (gameSpace == null) {
            gameSpace = GameCommand.getJoinableGameSpace();
        }
        GameCommand.joinAllPlayersToGame((class_2168)context.getSource(), gameSpace);
        return 1;
    }

    private static int joinAllQualifiedGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameSpace gameSpace = GameSpaceArgument.get(context, "game_space");
        GameCommand.joinAllPlayersToGame((class_2168)context.getSource(), gameSpace);
        return 1;
    }

    private static void joinAllPlayersToGame(class_2168 source, GameSpace gameSpace) {
        class_3324 playerManager = source.method_9211().method_3760();
        List<class_3222> players = playerManager.method_14571().stream().filter(player -> !GameSpaceManagerImpl.get().inGame((class_1657)player)).collect(Collectors.toList());
        JoinIntent intent = JoinIntent.PLAY;
        GameResult result = gameSpace.getPlayers().offer(players, intent);
        if (result.isError()) {
            source.method_9213((class_2561)result.errorCopy().method_27692(class_124.field_1061));
        }
    }

    private static void tryJoinGame(class_3222 player, GameSpace gameSpace, JoinIntent intent) {
        GameResult result = GamePlayerJoiner.tryJoin(player, gameSpace, intent);
        if (result.isError()) {
            player.method_64398((class_2561)result.errorCopy().method_27692(class_124.field_1061));
        }
    }

    private static GameSpace getJoinableGameSpace() throws CommandSyntaxException {
        return GameSpaceManagerImpl.get().getOpenGameSpaces().stream().max(Comparator.comparingInt(space -> space.getPlayers().size())).orElseThrow(() -> ((SimpleCommandExceptionType)NO_GAME_OPEN).create());
    }

    private static int locatePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)player);
        if (gameSpace == null) {
            throw PLAYER_NOT_IN_GAME.create((Object)player.method_5477());
        }
        ((class_2168)context.getSource()).method_9226(() -> GameTexts.Command.located(player, gameSpace), false);
        return 1;
    }

    private static int leaveGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)player);
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }
        Scheduler.INSTANCE.submit(server -> gameSpace.getPlayers().kick(player));
        return 1;
    }

    private static int startGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)source.method_9207());
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }
        GameResult startResult = gameSpace.requestStart();
        class_5250 message = startResult.isOk() ? GameTexts.Start.startedBy(source).method_27692(class_124.field_1080) : startResult.errorCopy().method_27692(class_124.field_1061);
        gameSpace.getPlayers().sendMessage((class_2561)message);
        return 1;
    }

    private static int stopGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)source.method_9207());
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }
        ManagedGameSpacePlayers playerSet = gameSpace.getPlayers();
        if (playerSet.size() <= 1) {
            GameCommand.stopGameConfirmed(context);
        } else {
            source.method_9226(() -> GameTexts.Stop.confirmStop().method_27692(class_124.field_1065), false);
        }
        return 1;
    }

    private static int stopGameConfirmed(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)source.method_9207());
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }
        MutablePlayerSet playerSet = gameSpace.getPlayers().copy(source.method_9211());
        try {
            gameSpace.close(GameCloseReason.CANCELED);
            class_5250 message = GameTexts.Stop.stoppedBy(source);
            playerSet.sendMessage((class_2561)message.method_27692(class_124.field_1080));
        }
        catch (Throwable throwable) {
            Plasmid.LOGGER.error("Failed to stop game", throwable);
            playerSet.sendMessage((class_2561)GameTexts.Stop.genericError().method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int listGames(CommandContext<class_2168> context) {
        class_2378 registry = ((class_2168)context.getSource()).method_30497().method_30530(PlasmidRegistryKeys.GAME_CONFIG);
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> GameTexts.Command.gameList().method_27692(class_124.field_1067), false);
        registry.method_42017().forEach(game -> {
            class_2960 id = game.method_40237().method_29177();
            source.method_9226(() -> {
                String command = "/game open " + String.valueOf(id);
                class_5250 link = GameConfig.name(game).method_27661().method_10862(GameTexts.commandLinkStyle(command));
                return GameTexts.Command.listEntry((class_2561)link);
            }, false);
        });
        return 1;
    }

    private static int kickPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3324 playerManager = source.method_9211().method_3760();
        Collection targets = class_2186.method_9312(context, (String)"targets");
        int successes = 0;
        for (class_3222 target : targets) {
            ManagedGameSpace gameSpace = GameSpaceManagerImpl.get().byPlayer((class_1657)target);
            if (gameSpace == null) continue;
            class_5250 message = GameTexts.Kick.kick(source, target).method_27692(class_124.field_1080);
            playerManager.method_43514((class_2561)message, false);
            Scheduler.INSTANCE.submit(server -> gameSpace.getPlayers().kick(target));
            ++successes;
        }
        return successes;
    }
}

