/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import xyz.nucleoid.plasmid.impl.command.argument.GamePortalArgument;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

public final class GamePortalCommand {
    public static final SimpleCommandExceptionType TARGET_IS_NOT_INTERFACE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.plasmid.game.portal.connect.target_is_not_interface"));
    public static final SimpleCommandExceptionType INTERFACE_ALREADY_CONNECTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.plasmid.game.portal.connect.interface_already_connected"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"game").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"portal").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"connect").requires(Permissions.require((String)"plasmid.command.game.portal.connect", (int)3))).then(((RequiredArgumentBuilder)GamePortalArgument.argument("portal").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(GamePortalCommand::connectEntity))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(GamePortalCommand::connectBlock))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"disconnect").requires(Permissions.require((String)"plasmid.command.game.portal.disconnect", (int)3))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(GamePortalCommand::disconnectEntity))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(GamePortalCommand::disconnectBlock)))).then(class_2170.method_9247((String)"open").then(GamePortalArgument.argument("portal").executes(GamePortalCommand::openPortal)))));
    }

    private static int openPortal(CommandContext<class_2168> context) throws CommandSyntaxException {
        GamePortal portal = GamePortalArgument.get(context, "portal");
        portal.requestJoin(((class_2168)context.getSource()).method_44023(), false);
        return 1;
    }

    private static int connectEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        GamePortal portal = GamePortalArgument.get(context, "portal");
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (entity instanceof GamePortalInterface) {
            GamePortalInterface portalInterface = (GamePortalInterface)entity;
            if (!portal.addInterface(portalInterface)) {
                throw INTERFACE_ALREADY_CONNECTED.create();
            }
            ((class_2168)context.getSource()).method_9226(() -> {
                class_5250 message = class_2561.method_43469((String)"text.plasmid.game.portal.connect.entity", (Object[])new Object[]{class_2561.method_54154((class_2960)portal.getId()), entity.method_5477()});
                return message.method_27692(class_124.field_1080);
            }, false);
            return 1;
        }
        throw TARGET_IS_NOT_INTERFACE.create();
    }

    private static int connectBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        GamePortal portal = GamePortalArgument.get(context, "portal");
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GamePortalInterface) {
            GamePortalInterface portalInterface = (GamePortalInterface)blockEntity;
            if (!portal.addInterface(portalInterface)) {
                throw INTERFACE_ALREADY_CONNECTED.create();
            }
            source.method_9226(() -> {
                class_5250 message = class_2561.method_43469((String)"text.plasmid.game.portal.connect.block", (Object[])new Object[]{class_2561.method_54154((class_2960)portal.getId()), pos.method_10263(), pos.method_10264(), pos.method_10260()});
                return message.method_27692(class_124.field_1080);
            }, false);
            return 1;
        }
        throw TARGET_IS_NOT_INTERFACE.create();
    }

    private static int disconnectEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        if (entity instanceof GamePortalInterface) {
            GamePortalInterface portalInterface = (GamePortalInterface)entity;
            portalInterface.invalidatePortal();
            ((class_2168)context.getSource()).method_9226(() -> {
                class_5250 message = class_2561.method_43469((String)"text.plasmid.game.portal.disconnect.entity", (Object[])new Object[]{entity.method_5477()});
                return message.method_27692(class_124.field_1080);
            }, false);
            return 1;
        }
        throw TARGET_IS_NOT_INTERFACE.create();
    }

    private static int disconnectBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos;
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2586 blockEntity = world.method_8321(pos = class_2262.method_9696(context, (String)"pos"));
        if (blockEntity instanceof GamePortalInterface) {
            GamePortalInterface portalInterface = (GamePortalInterface)blockEntity;
            portalInterface.invalidatePortal();
            source.method_9226(() -> {
                class_5250 message = class_2561.method_43469((String)"text.plasmid.game.portal.disconnect.block", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
                return message.method_27692(class_124.field_1080);
            }, false);
            return 1;
        }
        throw TARGET_IS_NOT_INTERFACE.create();
    }
}

