/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.common.ui;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import xyz.nucleoid.plasmid.api.game.common.ui.WaitingLobbyUiElement;
import xyz.nucleoid.plasmid.api.game.common.ui.WaitingLobbyUiLayout;
import xyz.nucleoid.plasmid.impl.game.common.ui.WaitingLobbyUiLayoutEntry;

public final class WaitingLobbyUiLayoutImpl
implements WaitingLobbyUiLayout {
    private static final int SIZE = 9;
    private final Consumer<GuiElementInterface[]> callback;
    private final List<WaitingLobbyUiElement> leadingElements = new ArrayList<WaitingLobbyUiElement>();
    private final List<WaitingLobbyUiElement> trailingElements = new ArrayList<WaitingLobbyUiElement>();

    public WaitingLobbyUiLayoutImpl(Consumer<GuiElementInterface[]> callback) {
        this.callback = callback;
    }

    @Override
    public void addLeading(WaitingLobbyUiElement element) {
        this.add(element, this.leadingElements);
    }

    @Override
    public void addTrailing(WaitingLobbyUiElement element) {
        this.add(element, this.trailingElements);
    }

    private void add(WaitingLobbyUiElement element, List<WaitingLobbyUiElement> elements) {
        Objects.requireNonNull(element);
        if (this.leadingElements.contains(element) || this.trailingElements.contains(element)) {
            throw new IllegalArgumentException("Element " + String.valueOf(element) + " has already been added to the layout");
        }
        if (this.leadingElements.size() + this.trailingElements.size() >= 9) {
            throw new IllegalStateException("Cannot have more than 9 elements in the layout");
        }
        elements.add(element);
    }

    private GuiElementInterface[] build() {
        WaitingLobbyUiLayoutEntry entry;
        Object[] elements = new GuiElementInterface[9];
        Arrays.fill(elements, GuiElement.EMPTY);
        if (this.leadingElements.isEmpty() && this.trailingElements.isEmpty()) {
            return elements;
        }
        HashMap<WaitingLobbyUiElement, WaitingLobbyUiLayoutEntry> elementsToEntries = new HashMap<WaitingLobbyUiElement, WaitingLobbyUiLayoutEntry>(this.leadingElements.size() + this.trailingElements.size());
        for (WaitingLobbyUiElement element : this.leadingElements) {
            elementsToEntries.put(element, new WaitingLobbyUiLayoutEntry(element));
        }
        for (WaitingLobbyUiElement element : this.trailingElements) {
            elementsToEntries.put(element, new WaitingLobbyUiLayoutEntry(element));
        }
        ArrayList<WaitingLobbyUiLayoutEntry> entries = new ArrayList<WaitingLobbyUiLayoutEntry>(elementsToEntries.values());
        entries.sort(Comparator.comparingInt(WaitingLobbyUiLayoutEntry::size));
        int shrinkIndex = 0;
        while (WaitingLobbyUiLayoutEntry.getTotalSize(entries) > 9) {
            WaitingLobbyUiLayoutEntry entry2 = entries.get(shrinkIndex);
            entry2.shrink();
            ++shrinkIndex;
        }
        int index = 0;
        for (WaitingLobbyUiElement element : this.leadingElements) {
            entry = (WaitingLobbyUiLayoutEntry)elementsToEntries.get(element);
            for (GuiElementInterface guiElement : entry.getGuiElements()) {
                elements[index] = guiElement;
                ++index;
            }
        }
        index = 8;
        for (WaitingLobbyUiElement element : this.trailingElements) {
            entry = (WaitingLobbyUiLayoutEntry)elementsToEntries.get(element);
            for (GuiElementInterface guiElement : entry.getGuiElements()) {
                elements[index] = guiElement;
                --index;
            }
        }
        return elements;
    }

    @Override
    public void refresh() {
        this.callback.accept(this.build());
    }

    public String toString() {
        return "WaitingLobbyUiLayoutImpl{leadingElements=" + String.valueOf(this.leadingElements) + ", trailingElements=" + String.valueOf(this.trailingElements) + "}";
    }
}

