/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameOpenProcedure;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameSpaceManager;
import xyz.nucleoid.plasmid.api.game.GameSpaceMetadata;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceUserIdManager;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.stimuli.EventSource;
import xyz.nucleoid.stimuli.Stimuli;
import xyz.nucleoid.stimuli.event.StimulusEvent;
import xyz.nucleoid.stimuli.selector.EventListenerSelector;

public final class GameSpaceManagerImpl
implements GameSpaceManager {
    private static final GameSpaceManagerImpl FALLBACK = new GameSpaceManagerImpl(null);
    private static GameSpaceManagerImpl instance;
    @Nullable
    private final MinecraftServer server;
    private final GameSpaceUserIdManager userIds = new GameSpaceUserIdManager();
    private final List<ManagedGameSpace> gameSpaces = new ArrayList<ManagedGameSpace>();
    private final Map<UUID, ManagedGameSpace> idToGameSpace = new Object2ObjectOpenHashMap();
    private final Map<class_2960, ManagedGameSpace> userIdToGameSpace = new Object2ObjectOpenHashMap();
    private final Map<class_5321<class_1937>, ManagedGameSpace> dimensionToGameSpace = new Reference2ObjectOpenHashMap();
    private final Map<UUID, ManagedGameSpace> playerToGameSpace = new Object2ObjectOpenHashMap();
    private final ListenerSelector listenerSelector = new ListenerSelector();

    private GameSpaceManagerImpl(@Nullable MinecraftServer server) {
        this.server = server;
    }

    public static void openServer(MinecraftServer server) {
        GameSpaceManagerImpl instance = GameSpaceManagerImpl.instance;
        if (instance != null) {
            instance.close();
        }
        instance = new GameSpaceManagerImpl(server);
        Stimuli.registerSelector((EventListenerSelector)instance.listenerSelector);
        GameSpaceManagerImpl.instance = instance;
    }

    public static void startClosing() {
        GameSpaceManagerImpl instance = GameSpaceManagerImpl.instance;
        if (instance != null) {
            instance.close();
        }
    }

    public static void closeServer() {
        instance = null;
    }

    public static GameSpaceManagerImpl get() {
        if (instance != null) {
            return instance;
        }
        return FALLBACK;
    }

    @Override
    public CompletableFuture<GameSpace> open(class_6880<GameConfig<?>> config) {
        if (this.server == null) {
            return CompletableFuture.failedFuture(new RuntimeException("Not initialized yet!"));
        }
        return CompletableFuture.supplyAsync(() -> GameConfig.openProcedure(this.server, config), (Executor)class_156.method_18349()).thenApplyAsync(procedure -> this.addGameSpace(procedure.configOverride() != null ? procedure.configOverride() : config, config, (GameOpenProcedure)procedure), (Executor)this.server);
    }

    private ManagedGameSpace addGameSpace(class_6880<GameConfig<?>> config, class_6880<GameConfig<?>> sourceConfig, GameOpenProcedure procedure) {
        if (this.server == null) {
            throw new RuntimeException("Not initialized yet!");
        }
        UUID id = UUID.randomUUID();
        class_2960 userId = this.userIds.acquire((GameConfig)config.comp_349());
        Preconditions.checkState((!this.userIdToGameSpace.containsKey(userId) ? 1 : 0) != 0, (Object)"duplicate GameSpace user id acquired");
        GameSpaceMetadata metadata = new GameSpaceMetadata(id, userId, config, sourceConfig);
        ManagedGameSpace gameSpace = new ManagedGameSpace(this.server, this, metadata);
        this.gameSpaces.add(gameSpace);
        this.idToGameSpace.put(id, gameSpace);
        this.userIdToGameSpace.put(userId, gameSpace);
        Plasmid.LOGGER.info("Game space {} (source: {}) opened", (Object)id, (Object)GameConfig.sourceName(config));
        ((GameEvents.GameSpaceOpened)GameEvents.OPENED.invoker()).onGameSpaceOpened(config, gameSpace);
        procedure.apply(gameSpace);
        return gameSpace;
    }

    @Override
    public Collection<GameSpace> getOpenGameSpaces() {
        return this.gameSpaces;
    }

    @Override
    @Nullable
    public ManagedGameSpace byId(UUID id) {
        if (this.server == null) {
            return null;
        }
        return this.idToGameSpace.get(id);
    }

    @Override
    @Nullable
    public ManagedGameSpace byUserId(class_2960 userId) {
        if (this.server == null) {
            return null;
        }
        return this.userIdToGameSpace.get(userId);
    }

    @Override
    @Nullable
    public ManagedGameSpace byWorld(class_1937 world) {
        if (this.server == null) {
            return null;
        }
        return this.dimensionToGameSpace.get(world.method_27983());
    }

    @Override
    @Nullable
    public ManagedGameSpace byPlayer(class_1657 player) {
        if (this.server == null) {
            return null;
        }
        return this.playerToGameSpace.get(player.method_5667());
    }

    @Override
    public boolean hasGame(class_1937 world) {
        if (this.server == null) {
            return false;
        }
        return this.dimensionToGameSpace.containsKey(world.method_27983());
    }

    @Override
    public boolean inGame(class_1657 player) {
        if (this.server == null) {
            return false;
        }
        return this.playerToGameSpace.containsKey(player.method_5667());
    }

    void removeGameSpace(ManagedGameSpace gameSpace) {
        GameSpaceMetadata metadata = gameSpace.getMetadata();
        this.idToGameSpace.remove(metadata.id(), gameSpace);
        this.userIdToGameSpace.remove(metadata.userId(), gameSpace);
        this.gameSpaces.remove(gameSpace);
        this.userIds.release(metadata.userId());
    }

    void addDimensionToGameSpace(ManagedGameSpace gameSpace, class_5321<class_1937> dimension) {
        this.dimensionToGameSpace.put(dimension, gameSpace);
    }

    void removeDimensionFromGameSpace(ManagedGameSpace gameSpace, class_5321<class_1937> dimension) {
        this.dimensionToGameSpace.remove(dimension, gameSpace);
    }

    void addPlayerToGameSpace(ManagedGameSpace gameSpace, class_3222 player) {
        this.playerToGameSpace.put(player.method_5667(), gameSpace);
    }

    void removePlayerFromGameSpace(ManagedGameSpace gameSpace, class_3222 player) {
        this.playerToGameSpace.remove(player.method_5667(), gameSpace);
    }

    private void close() {
        Stimuli.unregisterSelector((EventListenerSelector)this.listenerSelector);
        ArrayList gameSpaces = Lists.newArrayList(this.gameSpaces);
        this.gameSpaces.clear();
        for (ManagedGameSpace gameSpace : gameSpaces) {
            gameSpace.close(GameCloseReason.CANCELED);
        }
        this.idToGameSpace.clear();
        this.userIdToGameSpace.clear();
        this.dimensionToGameSpace.clear();
        this.playerToGameSpace.clear();
    }

    final class ListenerSelector
    implements EventListenerSelector {
        ListenerSelector() {
        }

        public <T> Iterator<T> selectListeners(MinecraftServer server, StimulusEvent<T> event, EventSource source) {
            ManagedGameSpace gameSpace = this.getGameSpaceFor(source);
            if (gameSpace != null) {
                return gameSpace.getBehavior().getInvokers(event).iterator();
            }
            return Collections.emptyIterator();
        }

        @Nullable
        private ManagedGameSpace getGameSpaceFor(EventSource source) {
            ManagedGameSpace gameSpace;
            class_1297 entity = source.getEntity();
            if (entity instanceof class_3222 && (gameSpace = GameSpaceManagerImpl.this.playerToGameSpace.get(entity.method_5667())) != null) {
                return gameSpace;
            }
            if (source.getDimension() != null) {
                return GameSpaceManagerImpl.this.dimensionToGameSpace.get(source.getDimension());
            }
            return null;
        }
    }
}

