/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.collect.Iterables;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameResources;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.event.GameEventExceptionHandler;
import xyz.nucleoid.plasmid.api.game.event.GameEventListeners;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleMap;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.stimuli.event.EventResult;
import xyz.nucleoid.stimuli.event.StimulusEvent;

public final class ManagedGameActivity
implements GameActivity {
    private final ManagedGameSpace space;
    private final GameEventListeners listeners;
    private final GameRuleMap rules = new GameRuleMap();
    private final GameResources resources = new GameResources();

    ManagedGameActivity(ManagedGameSpace space) {
        this.space = space;
        GameEventExceptionHandler exceptionHandler = ManagedGameActivity.createExceptionHandler(space);
        this.listeners = new GameEventListeners(exceptionHandler);
    }

    private static GameEventExceptionHandler createExceptionHandler(final ManagedGameSpace space) {
        return new GameEventExceptionHandler(){

            @Override
            public <T> void handleException(StimulusEvent<T> event, Throwable throwable) {
                String listenerName = event.getListenerType().getSimpleName();
                Plasmid.LOGGER.warn("An unexpected exception occurred while invoking {}", (Object)listenerName, (Object)throwable);
                space.getLifecycle().onError(space, throwable, "Invoking " + listenerName);
            }
        };
    }

    @Override
    public GameSpace getGameSpace() {
        return this.space;
    }

    @Override
    public ManagedGameActivity setRule(GameRuleType rule, EventResult result) {
        this.rules.set(rule, result);
        return this;
    }

    @Override
    public <T> ManagedGameActivity listen(StimulusEvent<T> event, T listener) {
        this.listeners.listen(event, listener);
        return this;
    }

    @Override
    public ManagedGameActivity addResource(AutoCloseable resource) {
        this.resources.add(resource);
        return this;
    }

    @Override
    @NotNull
    public <T> T invoker(StimulusEvent<T> event) {
        return this.listeners.getInvoker(event);
    }

    @Override
    @NotNull
    public <T> T propagatingInvoker(StimulusEvent<T> event) {
        return this.listeners.getPropagatingInvoker(event);
    }

    @Override
    @NotNull
    public <T> Iterable<T> getInvokers(StimulusEvent<T> event) {
        Iterable<T> eventInvokers = this.listeners.getInvokersOrNull(event);
        Iterable<T> ruleInvokers = this.rules.getInvokersOrNull(event);
        if (eventInvokers != null && ruleInvokers != null) {
            return Iterables.concat(eventInvokers, ruleInvokers);
        }
        if (ruleInvokers != null) {
            return ruleInvokers;
        }
        if (eventInvokers != null) {
            return eventInvokers;
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public EventResult testRule(GameRuleType rule) {
        return this.rules.test(rule);
    }

    public void onDestroy() {
        this.resources.close();
    }
}

