/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameAttachment;
import xyz.nucleoid.plasmid.api.game.GameBehavior;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameLifecycle;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameSpaceMetadata;
import xyz.nucleoid.plasmid.api.game.GameSpaceState;
import xyz.nucleoid.plasmid.api.game.GameSpaceStatistics;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.game.manager.GameActivityState;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameActivity;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpacePlayers;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpaceWorlds;
import xyz.nucleoid.plasmid.impl.player.LocalJoinAcceptor;
import xyz.nucleoid.plasmid.impl.player.LocalJoinOffer;

public final class ManagedGameSpace
implements GameSpace {
    private final MinecraftServer server;
    private final GameSpaceManagerImpl manager;
    private final GameSpaceMetadata metadata;
    private final ManagedGameSpacePlayers players;
    private final ManagedGameSpaceWorlds worlds;
    private final GameLifecycle lifecycle = new GameLifecycle();
    private final long openTime;
    private final GameActivityState state = new GameActivityState(this);
    private boolean closed;
    private final GameSpaceStatistics statistics = new GameSpaceStatistics();
    private final Map<GameAttachment<?>, Object> attachments = new Reference2ObjectOpenHashMap();

    ManagedGameSpace(MinecraftServer server, GameSpaceManagerImpl manager, GameSpaceMetadata metadata) {
        this.server = server;
        this.manager = manager;
        this.metadata = metadata;
        this.players = new ManagedGameSpacePlayers(this);
        this.worlds = new ManagedGameSpaceWorlds(this);
        this.openTime = server.method_30002().method_8510();
    }

    @Override
    public GameSpaceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setActivity(Consumer<GameActivity> builder) {
        try {
            this.state.setActivity(() -> {
                ManagedGameActivity activity = new ManagedGameActivity(this);
                builder.accept(activity);
                return activity;
            });
        }
        catch (Throwable throwable) {
            Plasmid.LOGGER.error("An unexpected error occurred while setting game activity", throwable);
            this.closeWithError("An unexpected error occurred while setting game activity");
        }
    }

    @Override
    public GameResult requestStart() {
        if (this.closed) {
            return GameResult.error((class_2561)GameTexts.Start.alreadyStarted());
        }
        GameResult startResult = ((GameEvents.RequestStart)GameEvents.START_REQUEST.invoker()).onRequestStart(this, null);
        if (startResult != null) {
            return startResult;
        }
        startResult = this.state.invoker(GameActivityEvents.REQUEST_START).onRequestStart();
        if (startResult != null) {
            return startResult;
        }
        return GameResult.error((class_2561)GameTexts.Start.genericError());
    }

    public void closeWithError(String message) {
        this.getPlayers().sendMessage((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
        this.close(GameCloseReason.ERRORED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(GameCloseReason reason) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList players = Lists.newArrayList((Iterable)this.players);
        Plasmid.LOGGER.info("Game space {} (source: {}) closing for reason {}", new Object[]{this.metadata.id(), GameConfig.sourceName(this.metadata.sourceConfig()), reason});
        ((GameEvents.GameSpaceClosing)GameEvents.CLOSING.invoker()).onGameSpaceClosing(this, reason);
        this.lifecycle.onClosing(this, reason);
        try {
            this.state.closeActivity(reason);
            for (class_3222 player : players) {
                this.lifecycle.onRemovePlayer(this, player);
                this.players.teleporter.teleportOut(player);
            }
        }
        catch (Throwable throwable) {
            for (class_3222 player : this.players) {
                this.manager.removePlayerFromGameSpace(this, player);
            }
            for (class_3218 world : this.worlds) {
                this.manager.removeDimensionFromGameSpace(this, (class_5321<class_1937>)world.method_27983());
            }
            this.players.clear();
            this.worlds.clear();
            this.manager.removeGameSpace(this);
            this.lifecycle.onClosed(this, players, reason);
            throw throwable;
        }
        for (class_3222 player : this.players) {
            this.manager.removePlayerFromGameSpace(this, player);
        }
        for (class_3218 world : this.worlds) {
            this.manager.removeDimensionFromGameSpace(this, (class_5321<class_1937>)world.method_27983());
        }
        this.players.clear();
        this.worlds.clear();
        this.manager.removeGameSpace(this);
        this.lifecycle.onClosed(this, players, reason);
    }

    @Override
    public ManagedGameSpacePlayers getPlayers() {
        return this.players;
    }

    @Override
    public ManagedGameSpaceWorlds getWorlds() {
        return this.worlds;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public GameLifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public long getTime() {
        return this.server.method_30002().method_8510() - this.openTime;
    }

    @Override
    public GameSpaceStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public GameSpaceState getState() {
        return this.state.invoker(GameActivityEvents.STATE_UPDATE).onStateUpdate(new GameSpaceState.Builder(this));
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nullable
    public <T> T getAttachment(GameAttachment<? extends T> attachment) {
        return (T)this.attachments.get(attachment);
    }

    @Override
    public <T> void setAttachment(GameAttachment<? super T> attachment, @Nullable T value) {
        if (value == null) {
            this.attachments.remove(attachment);
        } else {
            this.attachments.put(attachment, value);
        }
    }

    @Override
    public GameBehavior getBehavior() {
        return this.state;
    }

    JoinOfferResult offerPlayers(LocalJoinOffer offer) {
        if (this.closed) {
            return offer.reject((class_2561)GameTexts.Join.gameClosed());
        }
        if (offer.serverPlayers().stream().anyMatch(this.manager::inGame)) {
            return offer.reject((class_2561)GameTexts.Join.inOtherGame());
        }
        if (offer.serverPlayers().stream().anyMatch(p -> !Permissions.check((class_1297)p, (String)"plasmid.join_game", (boolean)true))) {
            return offer.reject((class_2561)GameTexts.Join.notAllowed());
        }
        return this.state.invoker(GamePlayerEvents.OFFER).onOfferPlayers(offer);
    }

    JoinAcceptorResult acceptPlayers(LocalJoinAcceptor acceptor) {
        return this.state.invoker(GamePlayerEvents.ACCEPT).onAcceptPlayers(acceptor);
    }

    void onAddPlayer(class_3222 player) {
        this.state.propagatingInvoker(GamePlayerEvents.JOIN).onAddPlayer(player);
        this.state.propagatingInvoker(GamePlayerEvents.ADD).onAddPlayer(player);
        this.manager.addPlayerToGameSpace(this, player);
        this.lifecycle.onAddPlayer(this, player);
        boolean spectator = this.players.spectators().contains(player);
        class_5250 joinMessage = (spectator ? GameTexts.Join.successSpectator(player) : GameTexts.Join.success(player)).method_27692(class_124.field_1054);
        joinMessage = this.state.invoker(GamePlayerEvents.JOIN_MESSAGE).onJoinMessageCreation(player, (class_2561)joinMessage, (class_2561)joinMessage);
        ((GameEvents.PlayerJoin)GameEvents.PLAYER_JOIN.invoker()).onPlayerJoin(this, player);
        if (joinMessage != null) {
            this.players.sendMessage((class_2561)joinMessage);
        }
    }

    void onPlayerRemove(class_3222 player) {
        boolean spectator = this.players.spectators().contains(player);
        class_5250 leaveMessage = (spectator ? GameTexts.Leave.spectator(player) : GameTexts.Leave.participant(player)).method_27692(class_124.field_1054);
        leaveMessage = this.state.invoker(GamePlayerEvents.LEAVE_MESSAGE).onLeaveMessageCreation(player, (class_2561)leaveMessage, (class_2561)leaveMessage);
        this.state.invoker(GamePlayerEvents.LEAVE).onRemovePlayer(player);
        this.state.invoker(GamePlayerEvents.REMOVE).onRemovePlayer(player);
        this.lifecycle.onRemovePlayer(this, player);
        ((GameEvents.PlayerLeft)GameEvents.PLAYER_LEFT.invoker()).onPlayerLeft(this, player);
        this.manager.removePlayerFromGameSpace(this, player);
        if (leaveMessage != null) {
            for (class_3222 receiver : this.players) {
                if (receiver == player) continue;
                receiver.method_64398((class_2561)leaveMessage);
            }
        }
    }

    void onAddWorld(RuntimeWorldHandle worldHandle) {
        this.manager.addDimensionToGameSpace(this, (class_5321<class_1937>)worldHandle.asWorld().method_27983());
    }

    void onRemoveWorld(class_5321<class_1937> dimension) {
        this.manager.removeDimensionFromGameSpace(this, dimension);
    }
}

