/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpacePlayers;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;
import xyz.nucleoid.plasmid.api.game.player.MutablePlayerSet;
import xyz.nucleoid.plasmid.api.game.player.PlayerSet;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.plasmid.impl.player.LocalJoinAcceptor;
import xyz.nucleoid.plasmid.impl.player.LocalJoinOffer;
import xyz.nucleoid.plasmid.impl.player.isolation.IsolatingPlayerTeleporter;

public final class ManagedGameSpacePlayers
implements GameSpacePlayers {
    private final ManagedGameSpace space;
    final MutablePlayerSet set;
    final MutablePlayerSet spectators;
    final MutablePlayerSet players;
    final IsolatingPlayerTeleporter teleporter;

    ManagedGameSpacePlayers(ManagedGameSpace space) {
        this.space = space;
        this.set = new MutablePlayerSet(space.getServer());
        this.spectators = new MutablePlayerSet(space.getServer());
        this.players = new MutablePlayerSet(space.getServer());
        this.teleporter = new IsolatingPlayerTeleporter(space.getServer());
    }

    @Override
    public GameResult simulateOffer(Collection<class_3222> players, JoinIntent intent) {
        if (players.stream().anyMatch(this.set::contains)) {
            return GameResult.error((class_2561)GameTexts.Join.alreadyJoined());
        }
        LocalJoinOffer offer = new LocalJoinOffer(players, intent);
        JoinOfferResult joinOfferResult = this.space.offerPlayers(offer);
        Objects.requireNonNull(joinOfferResult);
        JoinOfferResult joinOfferResult2 = joinOfferResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JoinOfferResult.Accept.class, JoinOfferResult.Reject.class}, (Object)joinOfferResult2, n)) {
            case 0 -> {
                JoinOfferResult.Accept accept = (JoinOfferResult.Accept)joinOfferResult2;
                yield GameResult.ok();
            }
            case 1 -> {
                JoinOfferResult.Reject reject = (JoinOfferResult.Reject)joinOfferResult2;
                yield GameResult.error(reject.reason());
            }
            default -> GameResult.error((class_2561)GameTexts.Join.genericError());
        };
    }

    @Override
    public GameResult offer(Collection<class_3222> players, JoinIntent intent) {
        GameResult result = this.attemptOffer(players, intent);
        if (result.isError()) {
            this.attemptGarbageCollection();
        }
        return result;
    }

    private GameResult attemptOffer(Collection<class_3222> players, JoinIntent intent) {
        if (players.stream().anyMatch(this.set::contains)) {
            return GameResult.error((class_2561)GameTexts.Join.alreadyJoined());
        }
        LocalJoinOffer offer = new LocalJoinOffer(players, intent);
        JoinOfferResult joinOfferResult = this.space.offerPlayers(offer);
        Objects.requireNonNull(joinOfferResult);
        JoinOfferResult joinOfferResult2 = joinOfferResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JoinOfferResult.Accept.class, JoinOfferResult.Reject.class}, (Object)joinOfferResult2, n)) {
            case 0 -> {
                JoinOfferResult.Accept accept = (JoinOfferResult.Accept)joinOfferResult2;
                yield this.accept(players, intent);
            }
            case 1 -> {
                JoinOfferResult.Reject reject = (JoinOfferResult.Reject)joinOfferResult2;
                yield GameResult.error(reject.reason());
            }
            default -> GameResult.error((class_2561)GameTexts.Join.genericError());
        };
    }

    private GameResult accept(Collection<class_3222> players, JoinIntent intent) {
        LocalJoinAcceptor acceptor = new LocalJoinAcceptor(players, intent);
        JoinAcceptorResult joinAcceptorResult = this.space.acceptPlayers(acceptor);
        Objects.requireNonNull(joinAcceptorResult);
        JoinAcceptorResult joinAcceptorResult2 = joinAcceptorResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalJoinAcceptor.Teleport.class}, (Object)joinAcceptorResult2, n)) {
            case 0: {
                LocalJoinAcceptor.Teleport teleport = (LocalJoinAcceptor.Teleport)joinAcceptorResult2;
                try {
                    MutablePlayerSet joiningSet = new MutablePlayerSet(this.space.getServer());
                    for (class_3222 player : players) {
                        this.teleporter.teleportIn(player, teleport::applyTeleport);
                        this.set.add(player);
                        this.byIntent(intent).add(player);
                        this.space.onAddPlayer(player);
                        joiningSet.add(player);
                    }
                    teleport.runCallbacks(joiningSet, intent);
                    return GameResult.ok();
                }
                catch (Throwable throwable) {
                    this.space.getLifecycle().onError(this.space, throwable, "handling LocalJoinAcceptor.Teleport");
                    return GameResult.error((class_2561)GameTexts.Join.unexpectedError());
                }
            }
        }
        throw new IllegalStateException("Accept event must be handled");
    }

    protected void attemptGarbageCollection() {
        if (this.set.isEmpty()) {
            this.space.close(GameCloseReason.GARBAGE_COLLECTED);
        }
    }

    @Override
    public boolean kick(class_3222 player) {
        if (this.remove(player)) {
            this.teleporter.teleportOut(player);
            return true;
        }
        return false;
    }

    @Override
    public MutablePlayerSet byIntent(JoinIntent joinIntent) {
        return switch (joinIntent) {
            default -> throw new MatchException(null, null);
            case JoinIntent.PLAY -> this.players;
            case JoinIntent.SPECTATE -> this.spectators;
        };
    }

    @Override
    public void modifyIntent(class_3222 player, JoinIntent joinIntent) {
        this.spectators.remove(player);
        this.players.remove(player);
        this.byIntent(joinIntent).add(player);
    }

    @Override
    public PlayerSet spectators() {
        return this.spectators;
    }

    @Override
    public PlayerSet participants() {
        return this.players;
    }

    public boolean remove(class_3222 player) {
        if (!this.set.contains(player)) {
            return false;
        }
        this.space.onPlayerRemove(player);
        this.set.remove(player);
        this.players.remove(player);
        this.spectators.remove(player);
        this.attemptGarbageCollection();
        return true;
    }

    void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(UUID id) {
        return this.set.contains(id);
    }

    @Override
    @Nullable
    public class_3222 getEntity(UUID id) {
        return this.set.getEntity(id);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    @NotNull
    public Iterator<class_3222> iterator() {
        return this.set.iterator();
    }

    public IsolatingPlayerTeleporter getTeleporter() {
        return this.teleporter;
    }
}

