/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;
import xyz.nucleoid.fantasy.util.GameRuleStore;
import xyz.nucleoid.plasmid.api.game.world.GameSpaceWorlds;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;

public final class ManagedGameSpaceWorlds
implements GameSpaceWorlds {
    private final ManagedGameSpace space;
    private final Map<class_5321<class_1937>, RuntimeWorldHandle> worlds = new Reference2ObjectOpenHashMap();

    ManagedGameSpaceWorlds(ManagedGameSpace space) {
        this.space = space;
    }

    @Override
    public class_3218 add(RuntimeWorldConfig worldConfig) {
        ManagedGameSpaceWorlds.applyDefaultsTo(worldConfig);
        RuntimeWorldHandle worldHandle = Fantasy.get((MinecraftServer)this.space.getServer()).openTemporaryWorld(worldConfig);
        this.worlds.put((class_5321<class_1937>)worldHandle.asWorld().method_27983(), worldHandle);
        this.space.onAddWorld(worldHandle);
        return worldHandle.asWorld();
    }

    @Override
    public class_3218 addPersistent(class_2960 identifier, RuntimeWorldConfig worldConfig) {
        class_3218 world = this.space.getServer().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)identifier));
        if (world != null) {
            throw new RuntimeException("World '" + String.valueOf(identifier) + "' is already loaded!");
        }
        ManagedGameSpaceWorlds.applyDefaultsTo(worldConfig);
        RuntimeWorldHandle worldHandle = Fantasy.get((MinecraftServer)this.space.getServer()).getOrOpenPersistentWorld(identifier, worldConfig);
        this.worlds.put((class_5321<class_1937>)worldHandle.asWorld().method_27983(), worldHandle);
        this.space.onAddWorld(worldHandle);
        return worldHandle.asWorld();
    }

    @Override
    public boolean remove(class_3218 world) {
        class_5321 dimension = world.method_27983();
        RuntimeWorldHandle worldHandle = this.worlds.remove(dimension);
        if (worldHandle != null) {
            this.space.onRemoveWorld((class_5321<class_1937>)dimension);
            worldHandle.unload();
            return true;
        }
        return false;
    }

    void clear() {
        for (RuntimeWorldHandle worldHandler : this.worlds.values()) {
            worldHandler.unload();
        }
        this.worlds.clear();
    }

    @Override
    @NotNull
    public Iterator<class_3218> iterator() {
        return Iterators.transform(this.worlds.values().iterator(), RuntimeWorldHandle::asWorld);
    }

    private static void applyDefaultsTo(RuntimeWorldConfig worldConfig) {
        GameRuleStore rules = worldConfig.getGameRules();
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_19409, false);
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_19396, false);
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_19406, false);
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_19389, false);
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_19390, false);
        ManagedGameSpaceWorlds.setDefaultRule(rules, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_59751, false);
    }

    private static void setDefaultRule(GameRuleStore rules, class_1928.class_4313<class_1928.class_4310> key, boolean value) {
        if (!rules.contains(key)) {
            rules.set(key, value);
        }
    }
}

