/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.portal;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.impl.portal.GamePortalDisplay;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

public final class GamePortal {
    private final class_2960 id;
    private final GamePortalBackend backend;
    private CustomValuesConfig custom = CustomValuesConfig.empty();
    private final Set<GamePortalInterface> interfaces = new ObjectOpenHashSet();
    private GamePortalDisplay lastDisplay = new GamePortalDisplay();
    private GamePortalDisplay currentDisplay = new GamePortalDisplay();

    public GamePortal(MinecraftServer server, class_2960 id, GamePortalBackend.Factory backendFactory) {
        this.id = id;
        this.backend = backendFactory.create(server, id);
    }

    void setCustom(CustomValuesConfig custom) {
        this.custom = custom;
    }

    public class_2960 getId() {
        return this.id;
    }

    public CustomValuesConfig getCustom() {
        return this.custom;
    }

    public class_2561 getName() {
        return this.backend.getName();
    }

    public List<class_2561> getDescription() {
        return this.backend.getDescription();
    }

    public class_1799 getIcon() {
        return this.backend.getIcon();
    }

    public int getPlayerCount() {
        return this.backend.getPlayerCount();
    }

    public int getSpectatorCount() {
        return this.backend.getSpectatorCount();
    }

    public int getMaxPlayerCount() {
        return this.backend.getMaxPlayerCount();
    }

    public void requestJoin(class_3222 player, boolean alt) {
        this.backend.applyTo(player, alt);
    }

    public boolean addInterface(GamePortalInterface itf) {
        if (itf.getPortal() == null && this.interfaces.add(itf)) {
            itf.setPortal(this);
            if (itf.updatePortalImmediately()) {
                itf.setDisplay(this.currentDisplay);
            }
            return true;
        }
        return false;
    }

    public boolean removeInterface(GamePortalInterface itf) {
        if (this.interfaces.remove(itf)) {
            itf.invalidatePortal();
            return true;
        }
        return false;
    }

    public void invalidate() {
        for (GamePortalInterface itf : this.interfaces) {
            itf.invalidatePortal();
        }
        this.interfaces.clear();
    }

    void updateDisplay() {
        this.flipDisplay();
        GamePortalDisplay display = this.currentDisplay;
        this.backend.populateDisplay(display);
        if (!display.equals(this.lastDisplay)) {
            for (GamePortalInterface itf : this.interfaces) {
                itf.setDisplay(display);
            }
        }
    }

    void flipDisplay() {
        GamePortalDisplay swap = this.currentDisplay;
        this.currentDisplay = this.lastDisplay;
        this.lastDisplay = swap;
        this.currentDisplay.clear();
    }

    public void provideGameSpaces(Consumer<GameSpace> consumer) {
        this.backend.provideGameSpaces(consumer);
    }

    public GamePortalBackend getBackend() {
        return this.backend;
    }

    @FunctionalInterface
    public static interface GuiProvider {
        public List<GuiElementInterface> getGuiElements();
    }
}

