/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.portal;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.util.TinyRegistry;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalConfig;
import xyz.nucleoid.plasmid.impl.portal.game.InvalidGamePortalBackend;

public final class GamePortalManager {
    public static final GamePortalManager INSTANCE = new GamePortalManager();
    private static final long DISPLAY_UPDATE_INTERVAL = 20L;
    private static final String PATH = "game_portals";
    private final TinyRegistry<GamePortal> portals = TinyRegistry.create();
    private Map<class_2960, GamePortalConfig> portalQueue;
    private MinecraftServer server;
    private long lastDisplayUpdateTime;

    private GamePortalManager() {
    }

    public void setup(MinecraftServer server) {
        this.server = server;
        Map<class_2960, GamePortalConfig> queue = this.portalQueue;
        if (queue != null) {
            this.portalQueue = null;
            this.loadPortalsFrom(server, queue);
        }
    }

    public void close(MinecraftServer server) {
        if (this.server == server) {
            this.server = null;
            this.portals.clear();
            this.portalQueue = null;
        }
    }

    @ApiStatus.Internal
    public void reload(class_5455 registryManager, class_3300 manager) {
        this.portals.clear();
        Map<class_2960, GamePortalConfig> configs = this.loadConfigs(registryManager, manager);
        if (this.server != null) {
            this.loadPortalsFrom(this.server, configs);
        } else {
            this.portalQueue = configs;
        }
    }

    private void loadPortalsFrom(MinecraftServer server, Map<class_2960, GamePortalConfig> queue) {
        for (Map.Entry<class_2960, GamePortalConfig> entry : queue.entrySet()) {
            class_2960 identifier = entry.getKey();
            GamePortalConfig config = entry.getValue();
            GamePortal portal = new GamePortal(server, identifier, config::createBackend);
            portal.setCustom(config.custom());
            this.portals.register(identifier, portal);
        }
    }

    private Map<class_2960, GamePortalConfig> loadConfigs(class_5455 registryManager, class_3300 manager) {
        Object2ObjectOpenHashMap configs = new Object2ObjectOpenHashMap();
        class_6903 ops = registryManager.method_57093((DynamicOps)JsonOps.INSTANCE);
        manager.method_14488(PATH, path -> path.method_12832().endsWith(".json")).forEach((path, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                class_2960 identifier = GamePortalManager.identifierFromPath(path);
                GamePortalConfig.CODEC.parse((DynamicOps)ops, (Object)json).resultOrPartial(error -> {
                    Plasmid.LOGGER.error("Failed to parse game portal at {}: {}", path, error);
                    if (PlasmidConfig.get().ignoreInvalidGames()) {
                        configs.put((Object)identifier, (Object)InvalidGamePortalBackend.CONFIG);
                    }
                }).ifPresent(config -> configs.put((Object)identifier, config));
            }
            catch (IOException e) {
                Plasmid.LOGGER.error("Failed to read game portal at {}", path, (Object)e);
            }
            catch (JsonParseException e) {
                Plasmid.LOGGER.error("Failed to parse game portal JSON at {}: {}", path, (Object)e);
            }
        });
        return configs;
    }

    private static class_2960 identifierFromPath(class_2960 location) {
        String path = location.method_12832();
        path = path.substring(PATH.length() + 1, path.length() - ".json".length());
        return class_2960.method_60655((String)location.method_12836(), (String)path);
    }

    public void tick() {
        MinecraftServer server = this.server;
        if (server == null) {
            return;
        }
        long time = server.method_30002().method_8510();
        if (time - this.lastDisplayUpdateTime > 20L) {
            this.updatePortalDisplays();
            this.lastDisplayUpdateTime = time;
        }
    }

    private void updatePortalDisplays() {
        for (GamePortal portal : this.portals.values()) {
            portal.updateDisplay();
        }
    }

    public Set<class_2960> keySet() {
        return this.portals.keySet();
    }

    public Collection<GamePortal> getPortals() {
        return this.portals.values();
    }

    @Nullable
    public GamePortal byId(class_2960 id) {
        return this.portals.get(id);
    }
}

