/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.impl.portal.menu;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.util.Guis;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.impl.portal.game.ConcurrentGamePortalBackend;
import xyz.nucleoid.plasmid.impl.portal.menu.GameMenuEntry;
import xyz.nucleoid.plasmid.impl.portal.menu.MenuEntry;
import xyz.nucleoid.plasmid.impl.portal.menu.MenuPortalConfig;

public final class MenuPortalBackend
implements GamePortalBackend {
    private final class_2561 name;
    private final List<MenuEntry> games;
    private final List<class_2561> description;
    private final class_1799 icon;

    MenuPortalBackend(class_2561 name, List<class_2561> description, class_1799 icon, List<MenuPortalConfig.Entry> games) {
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.games = this.buildGames(games);
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public List<class_2561> getDescription() {
        return this.description;
    }

    @Override
    public class_1799 getIcon() {
        return this.icon;
    }

    @Override
    public int getPlayerCount() {
        int count = 0;
        ReferenceOpenHashSet uniqueGameSpaces = new ReferenceOpenHashSet();
        this.provideGameSpaces(arg_0 -> ((ReferenceOpenHashSet)uniqueGameSpaces).add(arg_0));
        for (GameSpace entry : uniqueGameSpaces) {
            count += Math.max(0, entry.getState().players());
        }
        return count;
    }

    @Override
    public int getSpectatorCount() {
        int count = 0;
        ReferenceOpenHashSet uniqueGameSpaces = new ReferenceOpenHashSet();
        this.provideGameSpaces(arg_0 -> ((ReferenceOpenHashSet)uniqueGameSpaces).add(arg_0));
        for (GameSpace entry : uniqueGameSpaces) {
            count += Math.max(0, entry.getState().spectators());
        }
        return count;
    }

    @Override
    public void provideGameSpaces(Consumer<GameSpace> consumer) {
        for (MenuEntry entry : this.games) {
            entry.provideGameSpaces(consumer);
        }
    }

    private List<GuiElementInterface> getGuiElements() {
        ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
        for (MenuEntry game : this.games) {
            GuiElement uiEntry = game.createGuiElement();
            elements.add((GuiElementInterface)uiEntry);
        }
        return elements;
    }

    private List<MenuEntry> buildGames(List<MenuPortalConfig.Entry> configs) {
        ArrayList<MenuEntry> games = new ArrayList<MenuEntry>(configs.size());
        for (MenuPortalConfig.Entry configEntry : configs) {
            class_6880<GameConfig<?>> config = configEntry.game();
            ConcurrentGamePortalBackend game = new ConcurrentGamePortalBackend(config);
            games.add(new GameMenuEntry(game, configEntry.name().orElse(GameConfig.name(config)), configEntry.description().orElse(((GameConfig)config.comp_349()).description()), configEntry.icon().orElse(((GameConfig)config.comp_349()).icon())));
        }
        return games;
    }

    @Override
    public void applyTo(class_3222 player, boolean alt) {
        SimpleGui ui = Guis.createSelectorGui(player, this.name.method_27661(), true, this.getGuiElements());
        ui.open();
    }
}

