package xyz.nucleoid.plasmid.api.game;

import com.google.common.base.Preconditions;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

/**
 * Describes the result from a user-involved action with a {@link GameSpace}.
 * The result can either represent that the action was performed successfully ({@link GameResult#ok()}) or that an
 * issue occurred while trying to perform this action ({@link GameResult#error(class_2561)}).
 */
public final class GameResult {
    private static final GameResult OK = new GameResult(null);

    private final class_2561 error;

    private GameResult(class_2561 error) {
        this.error = error;
    }

    public static GameResult ok() {
        return OK;
    }

    /**
     * Returns a {@link GameResult} with the given {@link class_2561} as an error.
     *
     * @param error error in {@link class_2561} format
     * @return {@link GameResult} with the given error
     */
    public static GameResult error(class_2561 error) {
        Preconditions.checkNotNull(error, "error must not be null");
        return new GameResult(error);
    }

    /**
     * @return whether this {@link GameResult} is a success (no error).
     */
    public boolean isOk() {
        return this.error == null;
    }

    /**
     * @return whether this {@link GameResult} contains an error
     */
    public boolean isError() {
        return this.error != null;
    }

    /**
     * Returns the error result of this {@link GameResult} as a {@link class_2561}.
     *
     * <p>If no error occurred, null is returned.
     *
     * @return the error of this {@link GameResult}, or null if one does not exist
     */
    @Nullable
    public class_2561 error() {
        return this.error;
    }

    /**
     * Returns the error result of this {@link GameResult} as a copied {@link class_5250}.
     *
     * <p>If no error occurred, null is returned.
     *
     * @return the error of this {@link GameResult}, or null if one does not exist
     */
    @Nullable
    public class_5250 errorCopy() {
        var error = this.error;
        return error != null ? error.method_27661() : null;
    }
}
