package xyz.nucleoid.plasmid.api.game;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

@ApiStatus.NonExtendable
public interface GameSpaceManager {
    static GameSpaceManager get() {
        return GameSpaceManagerImpl.get();
    }

    CompletableFuture<GameSpace> open(class_6880<GameConfig<?>> config);

    Collection<GameSpace> getOpenGameSpaces();

    @Nullable
    GameSpace byId(UUID id);

    @Nullable
    GameSpace byUserId(class_2960 userId);

    @Nullable
    GameSpace byWorld(class_1937 world);

    @Nullable
    GameSpace byPlayer(class_1657 player);

    boolean hasGame(class_1937 world);

    boolean inGame(class_1657 player);
}
