package xyz.nucleoid.plasmid.api.game;

import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;

/**
 * Utility class containing various functions that supply {@link class_2561} instances.
 * <p>
 * This provides a common path for Plasmid and game implementations to share common messages.
 */
public final class GameTexts {
    public static class_5250 commandLink(String text, String command) {
        return class_2561.method_43470(text).method_10862(commandLinkStyle(command));
    }

    public static class_5250 commandLink(class_2561 text, String command) {
        return text.method_27661().method_10862(commandLinkStyle(command));
    }

    public static class_2583 commandLinkStyle(String command) {
        return commandLinkStyle(command, class_2561.method_43470(command));
    }

    public static class_2583 commandLinkStyle(String command, class_2561 hoverText) {
        return class_2583.field_24360
                .method_10958(new class_2558.class_10609(command))
                .method_10949(new class_2568.class_10613(hoverText))
                .method_27705(class_124.field_1078, class_124.field_1073);
    }

    public static final class Broadcast {
        public static class_5250 gameOpened(class_2168 source, GameSpace gameSpace) {
            var gameName = GameConfig.name(gameSpace.getMetadata().sourceConfig()).method_27661().method_27692(class_124.field_1080);

            return class_2561.method_43469("text.plasmid.game.open.opened", source.method_9223(), gameName)
                    .method_10852(GameTexts.Join.link(gameSpace));
        }

        public static class_5250 gameOpenedTesting(class_2168 source, GameSpace gameSpace) {
            var gameName = GameConfig.name(gameSpace.getMetadata().sourceConfig()).method_27661().method_27692(class_124.field_1080);

            return class_2561.method_43469("text.plasmid.game.open.opened.testing", source.method_9223(), gameName)
                    .method_10852(GameTexts.Join.link(gameSpace));
        }

        public static class_5250 propose(class_2168 source, GameSpace gameSpace) {
            var gameName = GameConfig.name(gameSpace.getMetadata().sourceConfig()).method_27661().method_27692(class_124.field_1080);

            return class_2561.method_43469("text.plasmid.game.propose", source.method_9223(), gameName)
                    .method_10852(GameTexts.Join.link(gameSpace));
        }

        public static class_5250 gameOpenError() {
            return class_2561.method_43471("text.plasmid.game.open.error");
        }
    }

    public static final class Command {
        public static class_5250 located(class_3222 player, GameSpace gameSpace) {
            var gameName = GameConfig.name(gameSpace.getMetadata().sourceConfig()).method_27661().method_27692(class_124.field_1080);

            return class_2561.method_43469("text.plasmid.game.locate.located", player.method_5476(), gameName)
                    .method_10852(GameTexts.Join.link(gameSpace));
        }

        public static class_5250 gameList() {
            return class_2561.method_43471("text.plasmid.game.list");
        }

        public static class_5250 listEntry(class_2561 entry) {
            return class_2561.method_43469("text.plasmid.entry", entry);
        }
    }

    public static final class Start {
        public static class_5250 genericError() {
            return class_2561.method_43471("text.plasmid.game.start_result.generic_error");
        }

        public static class_5250 alreadyStarted() {
            return class_2561.method_43471("text.plasmid.game.start_result.already_started");
        }

        public static class_5250 notEnoughPlayers() {
            return class_2561.method_43471("text.plasmid.game.start_result.not_enough_players");
        }

        public static class_5250 startedBy(class_2168 source) {
            return class_2561.method_43469("text.plasmid.game.started.player", source.method_9223());
        }
    }

    public static final class Stop {
        public static class_5250 stoppedBy(class_2168 source) {
            return class_2561.method_43469("text.plasmid.game.stopped.player", source.method_9223());
        }

        public static class_5250 confirmStop() {
            return class_2561.method_43471("text.plasmid.game.stop.confirm");
        }

        public static class_5250 genericError() {
            return class_2561.method_43471("text.plasmid.game.stopped.error");
        }
    }

    public static final class Join {
        public static class_5250 success(class_3222 player) {
            return class_2561.method_43469("text.plasmid.game.join", player.method_5476());
        }

        public static class_5250 successSpectator(class_3222 player) {
            return class_2561.method_43469("text.plasmid.game.join.spectate", player.method_5476());
        }

        public static class_5250 link(GameSpace gameSpace) {
            var hover = class_2561.method_43469("text.plasmid.join_link_hover", GameConfig.name(gameSpace.getMetadata().sourceConfig()));

            return class_2561.method_43471("text.plasmid.game.open.join")
                    .method_10862(commandLinkStyle("/game join " + gameSpace.getMetadata().userId(), hover));
        }

        public static class_5250 partyJoinError(int errorCount) {
            return class_2561.method_43469("text.plasmid.game.join.party.error", errorCount);
        }

        public static class_5250 genericError() {
            return class_2561.method_43471("text.plasmid.join_result.generic_error");
        }

        public static class_5250 unexpectedError() {
            return class_2561.method_43471("text.plasmid.join_result.error");
        }

        public static class_5250 gameClosed() {
            return class_2561.method_43471("text.plasmid.join_result.game_closed");
        }

        public static class_5250 gameFull() {
            return class_2561.method_43471("text.plasmid.join_result.game_full");
        }

        public static class_5250 alreadyJoined() {
            return class_2561.method_43471("text.plasmid.join_result.already_joined");
        }

        public static class_5250 inOtherGame() {
            return class_2561.method_43469(
                    "text.plasmid.join_result.in_other_game",
                    commandLink(
                            class_2561.method_43471("text.plasmid.join_result.in_other_game.leave_this_game"),
                            "/game leave"
                    )
            );
        }

        public static class_5250 notAllowed() {
            return class_2561.method_43471("text.plasmid.join_result.not_allowed");
        }

        public static class_5250 spectatorsOnly() {
            return class_2561.method_43471("text.plasmid.join_result.spectators_only");
        }

        public static class_5250 participantsOnly() {
            return class_2561.method_43471("text.plasmid.join_result.participants_only");
        }
    }

    public static final class Leave {
        public static class_5250 participant(class_3222 player) {
            return class_2561.method_43469("text.plasmid.game.leave", player.method_5476());
        }

        public static class_5250 spectator(class_3222 player) {
            return class_2561.method_43469("text.plasmid.game.leave.spectate", player.method_5476());
        }
    }


    public static final class Kick {
        public static class_5250 kick(class_2168 source, class_3222 target) {
            return source.method_43737() ? kickBy(source.method_44023(), target) : kick(target);
        }

        public static class_5250 kickBy(class_3222 source, class_3222 target) {
            return class_2561.method_43469("text.plasmid.game.kick.by", target.method_5476(), source.method_5476());
        }

        public static class_5250 kick(class_3222 target) {
            return class_2561.method_43469("text.plasmid.game.kick", target.method_5476());
        }
    }
}
