package xyz.nucleoid.plasmid.api.game.common.team.provider;

import xyz.nucleoid.plasmid.api.game.common.team.GameTeam;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamConfig;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_5251;

/**
 * Default team lists for various game sizes from 1 to 16 teams.
 *
 * <p>Colors are handpicked and the fewer the teams, the more contrasting are the colors.
 *
 * @author Hugman
 */
public final class DefaultTeamLists {
    private static final GameTeam BLUE = createTeam(class_1767.field_7966);
    private static final GameTeam GREEN = createTeam(class_1767.field_7942);
    private static final GameTeam YELLOW = createTeam(class_1767.field_7947);
    private static final GameTeam ORANGE = createTeam(class_1767.field_7946);
    private static final GameTeam RED = createTeam(class_1767.field_7964);
    private static final GameTeam BROWN = createTeam(class_1767.field_7957);

    private static final GameTeam LIME = createTeam(class_1767.field_7961);
    private static final GameTeam LIGHT_BLUE = createTeam(class_1767.field_7951);
    private static final GameTeam PINK = createTeam(class_1767.field_7954);
    private static final GameTeam PURPLE = createTeam(class_1767.field_7945);

    private static final GameTeam CYAN = createTeam(class_1767.field_7955);
    private static final GameTeam MAGENTA = createTeam(class_1767.field_7958);

    private static final GameTeam WHITE = createTeam(class_1767.field_7952);
    private static final GameTeam BLACK = createTeam(class_1767.field_7963);

    private static final GameTeam GRAY = createTeam(class_1767.field_7944);
    private static final GameTeam LIGHT_GRAY = createTeam(class_1767.field_7967);

    private static final GameTeam LIGHT_BLUE_AS_BLUE = createTeam("blue", class_1767.field_7951);
    private static final GameTeam LIME_AS_GREEN = createTeam("green", class_1767.field_7961);
    private static final GameTeam MAGENTA_AS_PURPLE = createTeam("purple", class_1767.field_7958);

    private static final TeamListProvider RANDOM_TWO = ofLists(List.of(
            List.of(LIGHT_BLUE_AS_BLUE, RED),
            List.of(BLUE, ORANGE),
            List.of(LIME_AS_GREEN, MAGENTA_AS_PURPLE),
            List.of(YELLOW, PURPLE),
            List.of(PINK, CYAN),
            List.of(RED, GREEN),
            List.of(LIGHT_BLUE_AS_BLUE, ORANGE)
    ));

    private static final TeamListProvider RANDOM_FOUR = ofLists(List.of(
            List.of(RED, BLUE, LIME_AS_GREEN, YELLOW),
            List.of(LIME_AS_GREEN, ORANGE, PINK, CYAN)
    ));

    private static final List<GameTeam> POOL_SMALLEST = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, RED);
    private static final List<GameTeam> POOL_FIVE = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, RED, MAGENTA_AS_PURPLE);
    private static final List<GameTeam> POOL_SEVEN = List.of(LIGHT_BLUE_AS_BLUE, LIME_AS_GREEN, YELLOW, ORANGE, RED, MAGENTA_AS_PURPLE, BROWN);
    private static final List<GameTeam> POOL_TEN = List.of(BLUE, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, PURPLE);
    private static final List<GameTeam> POOL_TWELVE = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE);
    private static final List<GameTeam> POOL_FOURTEEN = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE, WHITE, BLACK);
    private static final List<GameTeam> POOL_BIGGEST = List.of(BLUE, CYAN, LIGHT_BLUE, GREEN, LIME, YELLOW, ORANGE, RED, BROWN, PINK, MAGENTA, PURPLE, WHITE, LIGHT_GRAY, GRAY, BLACK);

    public static final Map<Integer, TeamListProvider> MAP = buildMap();

    private static Map<Integer, TeamListProvider> buildMap() {
        var map = new HashMap<Integer, TeamListProvider>();
        for (int i = 1; i <= 16; i++) {
            map.put(i, getEntry(i));
        }
        return map;
    }

    private static TeamListProvider getEntry(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Team list cannot be empty. Please provide a valid size between 0 and 16.");
        }
        if (size > 16) {
            throw new IllegalArgumentException("Team list cannot be over 16. Please provide a valid size between than 0 and 16.");
        }
        if (size == 2) {
            return RANDOM_TWO;
        }
        if (size == 4) {
            return RANDOM_FOUR;
        }
        if (size > 14) {
            return ofPool(POOL_BIGGEST, size);
        }
        if (size > 12) {
            return ofPool(POOL_FOURTEEN, size);
        }
        if (size > 10) {
            return ofPool(POOL_TWELVE, size);
        }
        if (size > 7) {
            return ofPool(POOL_TEN, size);
        }
        if (size > 5) {
            return ofPool(POOL_SEVEN, size);
        }
        if (size > 4) {
            return ofPool(POOL_FIVE, size);
        }
        return ofPool(POOL_SMALLEST, size);
    }

    private static TeamListProvider ofLists(List<List<GameTeam>> lists) {
        return new RandomTeamListProvider(lists.stream()
                .map(teamList -> (TeamListProvider) new ConstantTeamListProvider(teamList))
                .toList()
        );
    }

    private static TeamListProvider ofPool(List<GameTeam> pool, int size) {
        return new TrimTeamListProvider(new ConstantTeamListProvider(pool), size);
    }

    private static GameTeam createTeam(String name, class_1767 dyeColor) {
        // black text is barely readable, so we use dark gray instead
        var colors = dyeColor == class_1767.field_7963 ?
                new GameTeamConfig.Colors(
                        class_124.field_1063,
                        class_5251.method_27717(dyeColor.method_7787()),
                        dyeColor,
                        class_5251.method_27717(dyeColor.method_7790())
                )
                : GameTeamConfig.Colors.from(dyeColor);

        return new GameTeam(new GameTeamKey(name), GameTeamConfig.builder()
                .setName(class_2561.method_43471("color.minecraft." + name))
                .setColors(colors)
                .build());
    }

    private static GameTeam createTeam(class_1767 dyeColor) {
        return createTeam(dyeColor.method_7792(), dyeColor);
    }
}
