package xyz.nucleoid.plasmid.api.game.common.team.provider;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamList;

/**
 * Team provider that trims a list of teams from another provider to a specified size.
 *
 * @author Hugman
 */
public record TrimTeamListProvider(
        TeamListProvider provider,
        class_6017 size,
        boolean shuffle
) implements TeamListProvider {
    private static final boolean DEFAULT_SHUFFLE = true;

    public static final MapCodec<TrimTeamListProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            TeamListProvider.CODEC.fieldOf("provider").forGetter(TrimTeamListProvider::provider),
            class_6017.field_33451.fieldOf("size").forGetter(TrimTeamListProvider::size),
            Codec.BOOL.optionalFieldOf("shuffle", DEFAULT_SHUFFLE).forGetter(TrimTeamListProvider::shuffle)
    ).apply(instance, TrimTeamListProvider::new));

    public TrimTeamListProvider(TeamListProvider provider, int size) {
        this(provider, class_6016.method_34998(size), DEFAULT_SHUFFLE);
    }

    @Override
    public GameTeamList get(class_5819 random) {
        var list = provider.get(random).list();
        if (shuffle) {
            list = list.stream().sorted((a, b) -> random.method_43048(2) - 1).toList();
        }
        return new GameTeamList(list.subList(0, Math.min(size.method_35008(random), list.size())));
    }

    @Override
    public MapCodec<? extends TeamListProvider> getCodec() {
        return CODEC;
    }
}
