package xyz.nucleoid.plasmid.api.game.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.game.GameOpenContext;
import xyz.nucleoid.plasmid.api.game.GameOpenProcedure;
import xyz.nucleoid.plasmid.api.game.GameType;
import xyz.nucleoid.plasmid.api.game.GameTypes;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistryKeys;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;
import xyz.nucleoid.server.translations.api.language.ServerLanguage;
import xyz.nucleoid.server.translations.api.language.ServerLanguageDefinition;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public record GameConfig<C>(
        GameType<C> type,
        @Nullable class_2561 name,
        @Nullable class_2561 shortName,
        @Nullable List<class_2561> description,
        @Nullable class_1799 icon,
        CustomValuesConfig custom,
        C config
) {
    public static final Codec<GameConfig<?>> DIRECT_CODEC = PlasmidRegistries.GAME_TYPE.method_39673().dispatch(GameConfig::type, GameConfig::createTypedCodec);
    @Deprecated
    public static final Codec<GameConfig<?>> REGISTRY_CODEC = Codec.lazyInitialized(() -> {
        if (!PlasmidConfig.get().ignoreInvalidGames()) {
            return DIRECT_CODEC;
        }

        return Codec.withAlternative(DIRECT_CODEC, MapCodec.unitCodec(() -> new GameConfig<>(
                GameTypes.INVALID,
                null,
                null,
                null,
                null,
                null,
                ""
        )));
    });
    public static final Codec<class_6880<GameConfig<?>>> ENTRY_CODEC = class_5381.method_29749(PlasmidRegistryKeys.GAME_CONFIG, DIRECT_CODEC);
    public static final Codec<class_6885<GameConfig<?>>> ENTRY_LIST_CODEC = class_6895.method_40340(PlasmidRegistryKeys.GAME_CONFIG);
    /**
     * @deprecated Use {@link #ENTRY_CODEC} instead.
     */
    @Deprecated
    public static final Codec<class_6880<GameConfig<?>>> CODEC = ENTRY_CODEC;

    public static GameOpenProcedure openProcedure(MinecraftServer server, class_6880<GameConfig<?>> config) {
        //noinspection unchecked,rawtypes
        var context = new GameOpenContext(server, config);
        //noinspection unchecked
        return config.comp_349().type().open(context);
    }

    /**
     * @return the source location that this config was loaded from, if loaded from a file.
     */
    public static String sourceName(class_6880<GameConfig<?>> config) {
        return config.method_40230().map(e -> e.method_29177().toString()).orElse("[unknown source]");
    }

    /**
     * @return the name for this game config, defaulted to the game type name if none is specified
     */
    public static class_2561 name(final class_6880<GameConfig<?>> config) {
        var name = config.comp_349().name;
        if (name != null) {
            return name;
        }

        var translationKey = config.method_40230().map(key -> class_156.method_646("game", key.method_29177()))
                .filter(GameConfig::hasTranslationFor);
        if (translationKey.isPresent()) {
            return class_2561.method_43471(translationKey.get());
        }

        return config.comp_349().type.name();
    }

    /**
     * @return shortened version of the name, defaulted to standard name
     */
    public static class_2561 shortName(final class_6880<GameConfig<?>> config) {
        if (config.comp_349().shortName != null) {
            return config.comp_349().shortName;
        }
        return name(config);
    }

    /**
     * @return provided description of game, defaults to empty list
     */
    @Override
    public List<class_2561> description() {
        if (this.description != null) {
            return this.description;
        }
        return Collections.emptyList();
    }

    /**
     * @return game configs icon, defaults to grass block
     */
    @Override
    public class_1799 icon() {
        if (this.icon != null) {
            return this.icon;
        }

        return class_1802.field_8270.method_7854();
    }

    private static boolean hasTranslationFor(String translationKey) {
        var language = ServerLanguage.getLanguage(ServerLanguageDefinition.DEFAULT);
        return language.serverTranslations().contains(translationKey);
    }

    private static <C> MapCodec<GameConfig<C>> createTypedCodec(GameType<C> type) {
        return RecordCodecBuilder.mapCodec(i -> i.group(
                type.configCodec().forGetter(GameConfig::config),
                Metadata.MAP_CODEC.forGetter(Metadata::from)
        ).apply(i, (config, metadata) -> new GameConfig<>(
                type,
                metadata.name.orElse(null),
                metadata.shortName.orElse(null),
                metadata.description.orElse(null),
                metadata.icon,
                metadata.custom,
                config
        )));
    }

    @Deprecated(forRemoval = true)
    public GameOpenProcedure openProcedure(MinecraftServer server) {
        return openProcedure(server, class_6880.method_40223(this));
    }

    private record Metadata(
            Optional<class_2561> name,
            Optional<class_2561> shortName,
            Optional<List<class_2561>> description,
            class_1799 icon,
            CustomValuesConfig custom
    ) {
        static final MapCodec<Metadata> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
                PlasmidCodecs.TEXT.optionalFieldOf("name").forGetter(Metadata::name),
                PlasmidCodecs.TEXT.optionalFieldOf("short_name").forGetter(Metadata::shortName),
                MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description").forGetter(Metadata::description),
                MoreCodecs.ITEM_STACK.optionalFieldOf("icon", new class_1799(class_1802.field_8270)).forGetter(Metadata::icon),
                CustomValuesConfig.CODEC.fieldOf("custom").orElseGet(CustomValuesConfig::empty).forGetter(Metadata::custom)
        ).apply(i, Metadata::new));

        public static Metadata from(GameConfig<?> game) {
            return new Metadata(
                    Optional.ofNullable(game.name),
                    Optional.ofNullable(game.shortName),
                    Optional.ofNullable(game.description),
                    game.icon,
                    game.custom
            );
        }
    }
}
