package xyz.nucleoid.plasmid.api.game.stats;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

/**
 * Type-safe keys for identifying statistics.
 * <p>
 * Should have a corresponding translation key in the form <code>statistic.[key namespace].[key path]</code>
 * <p>
 * See {@link StatisticKeys} for some general keys for minigames to make use of.
 *
 * @param <T> The type of {@link Number} this key stores
 * @see StatisticKeys
 */
public record StatisticKey<T extends Number>(
        class_2960 id,
        ValueType valueType,
        boolean hidden
) {
    public StatisticKey {
        StatisticKey.validateKeyId(id);
    }

    @SuppressWarnings("unchecked")
    public JsonObject encodeValueUnchecked(Number value) {
        return this.encodeValue((T) value);
    }

    public JsonObject encodeValue(T value) {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.valueType.method_15434());
        obj.addProperty("value", value);
        obj.addProperty("hidden", this.hidden);
        return obj;
    }

    public String getTranslationKey() {
        return class_156.method_646("statistic", this.id);
    }

    public static StatisticKey<Integer> intKey(class_2960 id) {
        return new StatisticKey<>(id, ValueType.INT, false);
    }

    public static StatisticKey<Float> floatKey(class_2960 id) {
        return new StatisticKey<>(id, ValueType.FLOAT, false);
    }

    public static StatisticKey<Double> doubleKey(class_2960 id) {
        return new StatisticKey<>(id, ValueType.FLOAT, false);
    }

    public StatisticKey<T> hidden(boolean hidden) {
        return new StatisticKey<>(this.id, this.valueType, hidden);
    }

    /**
     * {@link StatisticKey} ids cannot contain '.' characters as they could potentially cause issues with the backend.
     *
     * @param id The {@link class_2960} to check
     */
    private static void validateKeyId(class_2960 id) {
        if (id.method_12836().contains(".") || id.method_12832().contains(".")) {
            throw new IllegalArgumentException("StatisticKey ids cannot contain '.'");
        }
    }

    public enum ValueType implements class_3542 {
        INT("int_total"),
        FLOAT("float_total"),
        ;

        public static final Codec<ValueType> CODEC = class_3542.method_28140(ValueType::values);

        private final String name;

        ValueType(String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return this.name;
        }
    }
}
