package xyz.nucleoid.plasmid.api.game.world.generator;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_4076;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import net.minecraft.class_7869;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.map_templates.BlockBounds;
import xyz.nucleoid.map_templates.MapChunk;
import xyz.nucleoid.map_templates.MapTemplate;

import java.util.concurrent.CompletableFuture;

public class TemplateChunkGenerator extends GameChunkGenerator {
    private final MapTemplate template;
    private final BlockBounds worldBounds;

    public TemplateChunkGenerator(MinecraftServer server, MapTemplate template) {
        super(createBiomeSource(server, template.getBiome()));

        this.template = template;
        this.worldBounds = template.getBounds();
    }

    @Override
    public void method_16129(class_5455 registryManager, class_7869 placementCalculator, class_5138 structureAccessor, class_2791 chunk, class_3485 structureTemplateManager, class_5321<class_1937> dimension) {
    }

    @Override
    public void method_16130(class_5281 world, class_5138 accessor, class_2791 chunk) {
    }

    @Override
    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        var chunkPos = chunk.method_12004();

        var chunkBounds = BlockBounds.ofChunk(chunk);
        if (!this.worldBounds.intersects(chunkBounds)) {
            return CompletableFuture.completedFuture(chunk);
        }

        return CompletableFuture.supplyAsync(() -> {
            var protoChunk = (class_2839) chunk;
            var mutablePos = new class_2338.class_2339();

            int minWorldX = chunkPos.method_8326();
            int minWorldZ = chunkPos.method_8328();

            int minSectionY = this.worldBounds.min().method_10264() >> 4;
            int maxSectionY = this.worldBounds.max().method_10264() >> 4;

            for (int sectionY = maxSectionY; sectionY >= minSectionY; sectionY--) {
                long sectionPos = class_4076.method_18685(chunkPos.field_9181, sectionY, chunkPos.field_9180);

                var templateChunk = this.template.getChunk(sectionPos);
                if (templateChunk == null) {
                    continue;
                }

                var section = protoChunk.method_38259(sectionY);
                section.method_16676();

                try {
                    int minWorldY = sectionY << 4;
                    this.addSection(minWorldX, minWorldY, minWorldZ, mutablePos, protoChunk, section, templateChunk);
                } finally {
                    section.method_16677();
                }
            }

            return chunk;
        });
    }

    private void addSection(int minWorldX, int minWorldY, int minWorldZ, class_2338.class_2339 templatePos, class_2839 chunk, class_2826 section, MapChunk templateChunk) {
        var oceanFloor = chunk.method_12032(class_2902.class_2903.field_13195);
        var worldSurface = chunk.method_12032(class_2902.class_2903.field_13194);

        for (int y = 0; y < 16; y++) {
            for (int z = 0; z < 16; z++) {
                for (int x = 0; x < 16; x++) {
                    var state = templateChunk.get(x, y, z);
                    if (state.method_26215()) {
                        continue;
                    }

                    int worldY = y + minWorldY;
                    templatePos.method_10103(x + minWorldX, worldY, z + minWorldZ);

                    section.method_12256(x, y, z, state, false);

                    oceanFloor.method_12597(x, worldY, z, state);
                    worldSurface.method_12597(x, worldY, z, state);

                    var blockEntityTag = this.template.getBlockEntityNbt(templatePos);
                    if (blockEntityTag != null) {
                        chunk.method_12042(blockEntityTag);
                    }
                }
            }
        }
    }

    @Override
    public void method_12107(class_3233 region) {
        var chunkPos = region.method_33561();

        var chunkBounds = BlockBounds.ofChunk(chunkPos, region);
        if (!this.worldBounds.intersects(chunkBounds)) {
            return;
        }

        var protoChunk = (class_2839) region.method_8392(chunkPos.field_9181, chunkPos.field_9180);

        int minSectionY = this.worldBounds.min().method_10264() >> 4;
        int maxSectionY = this.worldBounds.max().method_10264() >> 4;

        for (int sectionY = maxSectionY; sectionY >= minSectionY; sectionY--) {
            this.template.getEntitiesInChunk(chunkPos.field_9181, sectionY, chunkPos.field_9180).forEach(entity -> {
                var entityTag = entity.createEntityNbt(class_2338.field_10980);
                protoChunk.method_12302(entityTag);
            });
        }
    }

    @Override
    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        if (this.worldBounds.contains(x, z)) {
            return this.template.getTopY(x, z, heightmap);
        }
        return 0;
    }

    @Override
    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        if (this.worldBounds.contains(x, z)) {
            var mutablePos = new class_2338.class_2339(x, 0, z);

            int minY = this.worldBounds.min().method_10264();
            int maxY = this.worldBounds.max().method_10264();

            var column = new class_2680[maxY - minY + 1];
            for (int y = maxY; y >= minY; y--) {
                mutablePos.method_33098(y);
                column[y] = this.template.getBlockState(mutablePos);
            }

            return new class_4966(minY, column);
        }

        return GeneratorBlockSamples.VOID;
    }
}
