package xyz.nucleoid.plasmid.api.map.template.processor;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import xyz.nucleoid.map_templates.MapTemplate;

import java.util.Map;
import net.minecraft.class_10352;
import net.minecraft.class_2487;

/**
 * Template processor that replaces block entity NBT data in a {@link MapTemplate} based on a simple search and replace map.
 *
 * @param searchAndReplace the map of keys to replace with their corresponding values
 *
 * @author Hugman
 */
public record ReplaceBlockEntitiesTemplateProcessor(Map<String, String> searchAndReplace) implements MapTemplateProcessor {
    public static final MapCodec<ReplaceBlockEntitiesTemplateProcessor> CODEC = Codec.unboundedMap(Codec.STRING, Codec.STRING).fieldOf("search_and_replace").xmap(ReplaceBlockEntitiesTemplateProcessor::new, ReplaceBlockEntitiesTemplateProcessor::searchAndReplace);

    @Override
    public MapCodec<? extends MapTemplateProcessor> getCodec() {
        return CODEC;
    }

    @Override
    public void processTemplate(MapTemplate template, class_10352.class_10353 parameters) {
        template.getBounds().forEach(pos -> {
            var nbtCompound = template.getBlockEntityNbt(pos);
            if (nbtCompound instanceof class_2487) {
                if (searchAndReplace(nbtCompound, false)) {
                    template.setBlockEntityNbt(pos, nbtCompound);
                }
            }
        });
    }

    private boolean searchAndReplace(class_2487 compound, boolean hasChanged) {
        for (var key : compound.method_10541()) {
            var stringValue = compound.method_10558(key);
            if (stringValue.isPresent()) {
                var val = stringValue.get();
                for (var entry : searchAndReplace.entrySet()) {
                    if (val.equals(entry.getKey())) {
                        compound.method_10582(key, entry.getValue());
                        hasChanged = true;
                        break;
                    }
                }
            }
            var compoundValue = compound.method_10562(key);
            if (compoundValue.isPresent()) {
                var val = compoundValue.get();
                if (searchAndReplace(val, false)) {
                    hasChanged = true;
                    break;
                }
            }
            var listValue = compound.method_10554(key);
            if (listValue.isPresent()) {
                var list = listValue.get();
                for (var i = 0; i < list.size(); i++) {
                    var item = list.get(i);
                    if (item instanceof class_2487 itemCompound) {
                        if (searchAndReplace(itemCompound, false)) {
                            list.method_68585(i, itemCompound);
                            hasChanged = true;
                        }
                    }
                }
            }
        }
        return hasChanged;
    }
}
