package xyz.nucleoid.plasmid.api.map.template.processor;

import com.mojang.serialization.MapCodec;
import xyz.nucleoid.map_templates.MapTemplate;
import xyz.nucleoid.plasmid.api.game.GameOpenException;
import xyz.nucleoid.plasmid.api.map.MapLoadContexts;
import xyz.nucleoid.plasmid.api.util.ColoredBlocks;
import xyz.nucleoid.plasmid.api.util.ColoredItems;

import java.util.HashMap;
import java.util.List;
import net.minecraft.class_10352;
import net.minecraft.class_176;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

/**
 * Template processor that recolors blocks and items found in block entities (by their ID) in a template with team-specific colors.
 *
 * <p><strong>This processor requires {@link MapLoadContexts#TEAM_LIST} in the parameters before loading the processors.</strong>
 *
 * @param baseColors the colors to recolor. Each entry must correspond to a team of the loaded game.
 * @author Hugman
 * @see ColoredBlocks
 * @see ColoredItems
 * @see ReplaceBlocksTemplateProcessor
 * @see ReplaceBlockEntitiesTemplateProcessor
 */
public record TeamColorMapTemplateProcessor(List<class_1767> baseColors) implements MapTemplateProcessor {
    public static final MapCodec<TeamColorMapTemplateProcessor> CODEC = class_1767.field_41600.listOf().fieldOf("base_colors").xmap(TeamColorMapTemplateProcessor::new, TeamColorMapTemplateProcessor::baseColors);

    private static final class_176 CONTEXT_TYPE = new class_176.class_177().method_781(MapLoadContexts.TEAM_LIST).method_782();

    @Override
    public MapCodec<? extends MapTemplateProcessor> getCodec() {
        return CODEC;
    }

    @Override
    public void processTemplate(MapTemplate template, class_10352.class_10353 parameters) {
        parameters.method_64971(CONTEXT_TYPE);
        var teamList = parameters.method_64969(MapLoadContexts.TEAM_LIST).list();

        if (teamList.size() > this.baseColors.size()) {
            throw new GameOpenException(class_2561.method_43470("Not enough base colors provided for the number of teams."));
        }

        var blockMap = new HashMap<class_2248, class_2248>();
        var blockEntityReplace = new HashMap<String, String>();
        for (int i = 0; i < teamList.size(); i++) {
            var baseColor = this.baseColors.get(i);
            var teamColor = teamList.get(i).config().blockDyeColor();
            blockMap.put(ColoredBlocks.wool(baseColor), ColoredBlocks.wool(teamColor));
            blockMap.put(ColoredBlocks.carpet(baseColor), ColoredBlocks.carpet(teamColor));
            blockMap.put(ColoredBlocks.terracotta(baseColor), ColoredBlocks.terracotta(teamColor));
            blockMap.put(ColoredBlocks.glazedTerracotta(baseColor), ColoredBlocks.glazedTerracotta(teamColor));
            blockMap.put(ColoredBlocks.concrete(baseColor), ColoredBlocks.concrete(teamColor));
            blockMap.put(ColoredBlocks.concretePowder(baseColor), ColoredBlocks.concretePowder(teamColor));
            blockMap.put(ColoredBlocks.glass(baseColor), ColoredBlocks.glass(teamColor));
            blockMap.put(ColoredBlocks.glassPane(baseColor), ColoredBlocks.glassPane(teamColor));
            blockMap.put(ColoredBlocks.bed(baseColor), ColoredBlocks.bed(teamColor));
            blockMap.put(ColoredBlocks.shulkerBox(baseColor), ColoredBlocks.shulkerBox(teamColor));
            blockMap.put(ColoredBlocks.candle(baseColor), ColoredBlocks.candle(teamColor));
            blockMap.put(ColoredBlocks.candleCake(baseColor), ColoredBlocks.candleCake(teamColor));
            blockEntityReplace.put(class_7923.field_41178.method_10221(ColoredItems.dye(baseColor)).toString(), class_7923.field_41178.method_10221(ColoredItems.dye(teamColor)).toString());
            blockEntityReplace.put(class_7923.field_41178.method_10221(ColoredItems.bundle(baseColor)).toString(), class_7923.field_41178.method_10221(ColoredItems.bundle(teamColor)).toString());
            blockEntityReplace.put(class_7923.field_41178.method_10221(ColoredItems.harness(baseColor)).toString(), class_7923.field_41178.method_10221(ColoredItems.harness(teamColor)).toString());
        }

        new ReplaceBlocksTemplateProcessor(blockMap).processTemplate(template, parameters);

        for (var entry : blockMap.entrySet()) {
            blockEntityReplace.put(class_7923.field_41175.method_10221(entry.getKey()).toString(), class_7923.field_41175.method_10221(entry.getValue()).toString());
        }
        new ReplaceBlockEntitiesTemplateProcessor(blockEntityReplace).processTemplate(template, parameters);
    }
}
