package xyz.nucleoid.plasmid.api.util;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.SlotHolder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.layered.Layer;
import net.minecraft.class_10712;
import net.minecraft.class_1713;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2582;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7446;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.registry.*;
import org.jetbrains.annotations.Range;

import java.util.Collection;
import java.util.function.Consumer;

public final class Guis {
    private Guis() {
    }

    public static SimpleGui createSelectorGui(class_3222 player, class_5250 text, boolean includePlayerSlots, Consumer<SimpleGui> onClick, Consumer<SimpleGui> onClose, GuiElementInterface... elements) {
        var gui = new SimpleGui(selectScreenType(elements.length), player, includePlayerSlots) {
            @Override
            public boolean onClick(int index, ClickType type, class_1713 action, GuiElementInterface element) {
                onClick.accept(this);
                return super.onClick(index, type, action, element);
            }

            @Override
            public void onClose() {
                onClose.accept(this);
            }
        };

        gui.setTitle(text);

        buildSelector(gui, elements);
        return gui;
    }

    public static SimpleGui createSelectorGui(class_3222 player, class_5250 text, Consumer<SimpleGui> onClick, Consumer<SimpleGui> onClose, GuiElementInterface... elements) {
        return createSelectorGui(player, text, false, onClick, onClose, elements);
    }

    public static SimpleGui createSelectorGui(class_3222 player, class_5250 text, Consumer<SimpleGui> onClick, Consumer<SimpleGui> onClose, Collection<GuiElementInterface> elements) {
        return createSelectorGui(player, text, false, onClick, onClose, elements);
    }

    public static SimpleGui createSelectorGui(class_3222 player, class_5250 text, boolean includePlayerSlots, Consumer<SimpleGui> onClick, Consumer<SimpleGui> onClose, Collection<GuiElementInterface> elements) {
        return createSelectorGui(player, text, includePlayerSlots, onClick, onClose, elements.toArray(new GuiElementInterface[0]));
    }

    public static SimpleGui createSelectorGui(class_3222 player, class_5250 text, boolean includePlayerSlots, Collection<GuiElementInterface> elements) {
        return createSelectorGui(player, text, includePlayerSlots, gui -> {}, gui -> {}, elements.toArray(new GuiElementInterface[0]));
    }

    public static Layer createSelectorLayer(int height, int width, Collection<GuiElementInterface> elements) {
        return createSelectorLayer(height, width, elements.toArray(new GuiElementInterface[0]));
    }

    public static Layer createSelectorLayer(int height, int width, GuiElementInterface... elements) {
        var gui = new Layer(height, width);
        buildSelector(gui, elements);
        return gui;
    }

    private static void buildSelector(SlotHolder holder, GuiElementInterface... elements) {
        int lastRowCount = elements.length % holder.getWidth();
        int skippedElements = elements.length - lastRowCount;

        for (int i = 0; i < skippedElements; i++) {
            holder.setSlot(i, elements[i]);
        }

        int offset = (holder.getWidth() - lastRowCount) / 2;

        for (int i = skippedElements; i < elements.length; i++) {
            holder.setSlot(i + offset, elements[i]);
        }
    }

    public static class_1799 getNumericBanner(class_7871.class_7872 registries, @Range(from = 0, to = 9) int value) {
        class_7871<class_2582> patterns = registries.method_46751(class_7924.field_41252);
        return switch (Math.abs(value) % 10) {
            case 0 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39158, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39159, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944)
            );
            case 1 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39160, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39154, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39141, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 2 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39176, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39163, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 3 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39161, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39141, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39159, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 4 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39158, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39139, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39159, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39161, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 5 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39176, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39162, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 6 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39159, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39137, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39161, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39158, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 7 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39163, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 8 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39162, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            case 9 -> createBanner(new class_9307.class_3750()
                    .method_58124(patterns, class_7446.field_39158, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39139, class_1767.field_7944)
                    .method_58124(patterns, class_7446.field_39161, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39157, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39159, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39156, class_1767.field_7952)
                    .method_58124(patterns, class_7446.field_39140, class_1767.field_7944));
            default -> throw new IllegalStateException();
        };
    }

    private static class_3917<?> selectScreenType(int rowCount) {
        return switch (class_3532.method_15386(((float) rowCount) / 9)) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            case 3 -> class_3917.field_17326;
            case 4 -> class_3917.field_18666;
            case 5 -> class_3917.field_18667;
            default -> class_3917.field_17327;
        };
    }

    private static class_1799 createBanner(class_9307.class_3750 patterns) {
        class_1799 stack = class_1802.field_8617.method_7854();
        stack.method_57379(class_9334.field_49631, class_5244.field_39003);
        stack.method_57368(class_9334.field_56400, class_10712.field_56318, tooltipDisplay -> tooltipDisplay.method_67215(class_9334.field_49619, true));
        stack.method_57379(class_9334.field_49619, patterns.method_57573());
        return stack;
    }
}
