package xyz.nucleoid.plasmid.api.util;

import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.impl.player.PlayerMapImpl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

/**
 * This is a map that provides extra utility methods allowing you to easily use this map with {@link class_3222}, as with the backing PlayerRef.
 * @param <T> the type of stored values
 */
public interface PlayerMap<T> extends Map<PlayerRef, T> {
    static <T> PlayerMap<T> of(Map<PlayerRef, T> map) {
        return new PlayerMapImpl<>(map);
    }

    static <T> PlayerMap<T> createHashMap() {
        return new PlayerMapImpl<>(new HashMap<>());
    }

    static <T> PlayerMap<T> createHashMap(int size) {
        return new PlayerMapImpl<>(new HashMap<>(size));
    }
    boolean containsKey(class_3222 key);
    T get(class_3222 key);
    @Nullable
    T put(class_3222 key, T value);
    T remove(class_3222 key);

    void forEachPlayer(GameSpace gameSpace, BiConsumer<class_3222, T> consumer);
    void forEachPlayer(class_3218 world, BiConsumer<class_3222, T> consumer);
    void forEachPlayer(MinecraftServer server, BiConsumer<class_3222, T> consumer);

    Map<PlayerRef, T> getBackingMap();
}
