package xyz.nucleoid.plasmid.api.util;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameSpace;

import java.util.UUID;
import java.util.function.Consumer;

public record PlayerRef(UUID id) {
    public static PlayerRef of(class_1657 player) {
        return new PlayerRef(player.method_5667());
    }

    public static PlayerRef of(GameProfile profile) {
        return new PlayerRef(profile.id());
    }

    public static PlayerRef ofUnchecked(UUID id) {
        return new PlayerRef(id);
    }

    @Nullable
    public class_3222 getEntity(GameSpace gameSpace) {
        return gameSpace.getPlayers().getEntity(this.id);
    }

    @Nullable
    public class_3222 getEntity(class_3218 world) {
        return this.getEntity(world.method_8503());
    }

    @Nullable
    public class_3222 getEntity(MinecraftServer server) {
        return server.method_3760().method_14602(this.id);
    }

    public boolean isOnline(GameSpace gameSpace) {
        return this.getEntity(gameSpace) != null;
    }

    public boolean isOnline(class_3218 world) {
        return this.getEntity(world) != null;
    }

    public boolean isOnline(MinecraftServer server) {
        return this.getEntity(server) != null;
    }

    public void ifOnline(GameSpace gameSpace, Consumer<class_3222> consumer) {
        class_3222 player = this.getEntity(gameSpace);
        if (player != null) {
            consumer.accept(player);
        }
    }

    public void ifOnline(class_3218 world, Consumer<class_3222> consumer) {
        class_3222 player = this.getEntity(world);
        if (player != null) {
            consumer.accept(player);
        }
    }

    public void ifOnline(MinecraftServer server, Consumer<class_3222> consumer) {
        class_3222 player = this.getEntity(server);
        if (player != null) {
            consumer.accept(player);
        }
    }
}
