package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import xyz.nucleoid.plasmid.api.chat.ChatChannel;
import xyz.nucleoid.plasmid.api.chat.HasChatChannel;

import static net.minecraft.class_2170.method_9247;

public class ChatCommand {
    // @formatter:off
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("chat")
                .then(method_9247("all").executes(ChatCommand::switchToAll))
                .then(method_9247("team").executes(ChatCommand::switchToTeam))
        );
    }
    // @formatter:on

    public static int switchToAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var player = ctx.getSource().method_9207();
        ((HasChatChannel) player).setChatChannel(ChatChannel.ALL);
        player.method_7353(class_2561.method_43471("text.plasmid.chat.switch.all").method_27692(class_124.field_1075), false);
        return Command.SINGLE_SUCCESS;
    }

    public static int switchToTeam(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var player = ctx.getSource().method_9207();
        ((HasChatChannel) player).setChatChannel(ChatChannel.TEAM);
        player.method_7353(class_2561.method_43471("text.plasmid.chat.switch.team").method_27692(class_124.field_1075), false);
        return Command.SINGLE_SUCCESS;
    }
}
