package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2561;
import xyz.nucleoid.plasmid.impl.command.argument.GamePortalArgument;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class GamePortalCommand {
    public static final SimpleCommandExceptionType TARGET_IS_NOT_INTERFACE = new SimpleCommandExceptionType(
            class_2561.method_43471("text.plasmid.game.portal.connect.target_is_not_interface")
    );

    public static final SimpleCommandExceptionType INTERFACE_ALREADY_CONNECTED = new SimpleCommandExceptionType(
            class_2561.method_43471("text.plasmid.game.portal.connect.interface_already_connected")
    );

    // @formatter:off
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("game")
                .then(method_9247("portal")
                    .then(method_9247("connect")
                        .requires(Permissions.require("plasmid.command.game.portal.connect", 3))
                        .then(GamePortalArgument.argument("portal")
                        .then(method_9244("entity", class_2186.method_9309()).executes(GamePortalCommand::connectEntity))
                        .then(method_9244("pos", class_2262.method_9698()).executes(GamePortalCommand::connectBlock))
                    ))
                    .then(method_9247("disconnect")
                        .requires(Permissions.require("plasmid.command.game.portal.disconnect", 3))
                        .then(method_9244("entity", class_2186.method_9309()).executes(GamePortalCommand::disconnectEntity))
                        .then(method_9244("pos", class_2262.method_9698()).executes(GamePortalCommand::disconnectBlock))
                    )
                    .then(method_9247("open")
                        .then(GamePortalArgument.argument("portal").executes(GamePortalCommand::openPortal))
                    )
                )
        );
    }
    // @formatter:on

    private static int openPortal(CommandContext<class_2168> context) throws CommandSyntaxException {
        var portal = GamePortalArgument.get(context, "portal");
        portal.requestJoin(context.getSource().method_44023(), false);
        return 1;
    }

    private static int connectEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        var portal = GamePortalArgument.get(context, "portal");

        var entity = class_2186.method_9313(context, "entity");

        if (entity instanceof GamePortalInterface portalInterface) {
            if (!portal.addInterface(portalInterface)) {
                throw INTERFACE_ALREADY_CONNECTED.create();
            }

            context.getSource().method_9226(() -> {
                var message = class_2561.method_43469("text.plasmid.game.portal.connect.entity", class_2561.method_54154(portal.getId()), entity.method_5477());
                return message.method_27692(class_124.field_1080);
            }, false);

            return Command.SINGLE_SUCCESS;
        } else {
            throw TARGET_IS_NOT_INTERFACE.create();
        }
    }

    private static int connectBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        var source = context.getSource();
        var world = source.method_9225();

        var portal = GamePortalArgument.get(context, "portal");
        var pos = class_2262.method_9696(context, "pos");

        var blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GamePortalInterface portalInterface) {
            if (!portal.addInterface(portalInterface)) {
                throw INTERFACE_ALREADY_CONNECTED.create();
            }

            source.method_9226(() -> {
                var message = class_2561.method_43469("text.plasmid.game.portal.connect.block", class_2561.method_54154(portal.getId()), pos.method_10263(), pos.method_10264(), pos.method_10260());
                return message.method_27692(class_124.field_1080);
            }, false);

            return Command.SINGLE_SUCCESS;
        } else {
            throw TARGET_IS_NOT_INTERFACE.create();
        }
    }

    private static int disconnectEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        var entity = class_2186.method_9313(context, "entity");

        if (entity instanceof GamePortalInterface portalInterface) {
            portalInterface.invalidatePortal();

            context.getSource().method_9226(() -> {
                var message = class_2561.method_43469("text.plasmid.game.portal.disconnect.entity", entity.method_5477());
                return message.method_27692(class_124.field_1080);
            }, false);

            return Command.SINGLE_SUCCESS;
        } else {
            throw TARGET_IS_NOT_INTERFACE.create();
        }
    }

    private static int disconnectBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        var source = context.getSource();
        var world = source.method_9225();

        var pos = class_2262.method_9696(context, "pos");

        var blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GamePortalInterface portalInterface) {
            portalInterface.invalidatePortal();

            source.method_9226(() -> {
                var message = class_2561.method_43469("text.plasmid.game.portal.disconnect.block", pos.method_10263(), pos.method_10264(), pos.method_10260());
                return message.method_27692(class_124.field_1080);
            }, false);

            return Command.SINGLE_SUCCESS;
        } else {
            throw TARGET_IS_NOT_INTERFACE.create();
        }
    }
}
