package xyz.nucleoid.plasmid.impl.command.ui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameSpace;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.util.Guis;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;

import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5244;

public class GameJoinUi extends SimpleGui {
    private static final GuiElementInterface EMPTY = new GuiElementBuilder(class_1802.field_8871).hideTooltip().build();

    private static final int NAVBAR_POS = 81;
    private final class_3222 player;
    private final JoinIntent joinIntent;
    private int tick;
    private int page = 0;
    private int pageSize;

    public GameJoinUi(class_3222 player, JoinIntent intent) {
        super(class_3917.field_17327, player, true);
        this.joinIntent = intent;
        this.player = player;
        this.setTitle(class_2561.method_43471("text.plasmid.ui.game_join.title"));
        this.updateUi();
    }

    private static void tryJoinGame(class_3222 player, GameSpace gameSpace, JoinIntent joinIntent) {
        player.method_51469().method_8503().execute(() -> {
            var result = GamePlayerJoiner.tryJoin(player, gameSpace, joinIntent);
            if (result.isError()) {
                player.method_64398(result.errorCopy().method_27692(class_124.field_1061));
            }
        });
    }

    @Override
    public void onTick() {
        super.onTick();
        this.tick++;
        if (this.tick % 20 == 0) {
            this.updateUi();
        }
    }

    private void updateUi() {
        int i = 0;
        int gameI = 0;

        var games = new ArrayList<>(GameSpaceManagerImpl.get().getOpenGameSpaces());
        games.sort(Comparator.comparingInt(space -> -space.getPlayers().size()));

        int limit = this.size;
        this.pageSize = 0;

        if (games.size() > this.size) {
            limit = NAVBAR_POS;
            this.pageSize = games.size() / NAVBAR_POS;
        }

        this.page = class_3532.method_15340(this.page, 0, this.pageSize);

        for (var gameSpace : games) {
            if (gameI >= this.page * NAVBAR_POS) {
                if (i < limit) {
                    this.setSlot(i++, this.createIconFor(gameSpace));
                }
            }
            gameI++;
        }

        for (; i < limit; i++) {
            this.clearSlot(i);
        }

        if (this.pageSize != 0) {
            boolean hasPrevious = this.page != 0;
            boolean hasNext = this.page < this.pageSize;

            this.setSlot(NAVBAR_POS, EMPTY);
            this.setSlot(NAVBAR_POS + 1, EMPTY);

            this.setSlot(NAVBAR_POS + 2, new GuiElementBuilder(hasPrevious ? class_1802.field_8581 : class_1802.field_8157)
                    .setName(class_2561.method_43471("spectatorMenu.previous_page").method_27692(hasPrevious ? class_124.field_1065 : class_124.field_1063))
                    .setCallback((x, y, z) -> this.changePage(-1))
            );
            int pageValue = this.page + 1;

            var registries = this.player.method_56673();
            this.setSlot(NAVBAR_POS + 3, Guis.getNumericBanner(registries, pageValue / 100));
            this.setSlot(NAVBAR_POS + 4, Guis.getNumericBanner(registries, pageValue / 10));
            this.setSlot(NAVBAR_POS + 5, Guis.getNumericBanner(registries, pageValue));

            this.setSlot(NAVBAR_POS + 6, new GuiElementBuilder(hasNext ? class_1802.field_8581 : class_1802.field_8157)
                    .setName(class_2561.method_43471("spectatorMenu.next_page").method_27692(hasNext ? class_124.field_1065 : class_124.field_1063))
                    .setCallback((x, y, z) -> this.changePage(1))
            );

            this.setSlot(NAVBAR_POS + 7, EMPTY);
            this.setSlot(NAVBAR_POS + 8, EMPTY);
        }
    }

    private void changePage(int change) {
        this.page = class_3532.method_15340(this.page + change, 0, this.pageSize);
        this.updateUi();
    }

    private GuiElementBuilder createIconFor(GameSpace gameSpace) {
        var state = gameSpace.getState();
        var sourceConfig = gameSpace.getMetadata().sourceConfig();
        var element = GuiElementBuilder.from(sourceConfig.comp_349().icon().method_7972()).hideDefaultTooltip()
                .setName(GameConfig.name(sourceConfig).method_27661());

        for (var line : sourceConfig.comp_349().description()) {
            var text = line.method_27661();

            if (line.method_10866().method_10973() == null) {
                text.method_10862(line.method_10866().method_10977(class_124.field_1080));
            }

            element.addLoreLine(text);
        }

        boolean allowSpace = true;

        if (!state.state().hidden()) {
            element.addLoreLine(class_5244.field_39003);
            element.addLoreLine(class_2561.method_43470(" ").method_10852(state.state().display()).method_27692(class_124.field_1068));
            allowSpace = false;
        }

        if (state.players() > -1) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }
            element.addLoreLine(class_2561.method_43473()
                    .method_10852(class_2561.method_43470("» ").method_27692(class_124.field_1063))
                    .method_10852(class_2561.method_43469("text.plasmid.ui.game_join.players",
                            class_2561.method_43470(state.players() + (state.maxPlayers() > 0 ? " / " + state.maxPlayers() : "")).method_27692(class_124.field_1054)).method_27692(class_124.field_1065))
            );
        }

        if (state.spectators() > 0) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }

            element.addLoreLine(class_2561.method_43473()
                    .method_10852(class_2561.method_43470("» ").method_27692(class_124.field_1063))
                    .method_10852(class_2561.method_43469("text.plasmid.ui.game_join.spectators",
                            class_2561.method_43470( state.spectators() + "").method_27692(class_124.field_1054)).method_27692(class_124.field_1065))
            );
        }

        var actionType = this.joinIntent == JoinIntent.PLAY ? GamePortalBackend.ActionType.PLAY : GamePortalBackend.ActionType.SPECTATE;

        if (actionType != GamePortalBackend.ActionType.NONE) {
            element.addLoreLine(class_2561.method_43473().method_10852(class_2561.method_43470(" [ ").method_27692(class_124.field_1080))
                    .method_10852(actionType.text())
                    .method_10852(class_2561.method_43470(" ]").method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_36139(0x76ed6f)));
        }

        element.hideDefaultTooltip();
        element.setCallback((a, b, c, d) -> tryJoinGame(this.getPlayer(), gameSpace, joinIntent));

        return element;
    }
}
