package xyz.nucleoid.plasmid.impl.compatibility;

import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.api.util.InventoryUtil;

import java.util.List;

public class TrinketsCompatibility {
    private static final boolean ENABLED = FabricLoader.getInstance().isModLoaded("trinkets");


    public static void onInitialize() {
        if (!ENABLED) {
            return;
        }
        Plasmid.LOGGER.info("Trinkets compat loaded");

        InventoryUtil.addCustomHandler(new InventoryUtil.CustomInventoryHandler() {
            @Override
            public void clear(class_3222 player) {
                var component = TrinketsApi.getTrinketComponent(player);
                if (component.isEmpty()) {
                    return;
                }

                for (var x : component.get().getInventory().values()) {
                    for (var y : x.values()) {
                        y.method_5448();
                    }
                }
                component.get().getInventory().clear();
                component.get().getTrackingUpdates().forEach(TrinketInventory::method_5448);
                component.get().getGroups().clear();
                component.get().update();
                EntitySlotLoader.SERVER.sync(List.of(player));
            }
        });
    }

}
