package xyz.nucleoid.plasmid.impl.game.manager;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;
import xyz.nucleoid.fantasy.util.GameRuleStore;
import xyz.nucleoid.plasmid.api.game.world.GameSpaceWorlds;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_12279;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public final class ManagedGameSpaceWorlds implements GameSpaceWorlds {
    private final ManagedGameSpace space;

    private final Map<class_5321<class_1937>, RuntimeWorldHandle> worlds = new Reference2ObjectOpenHashMap<>();

    ManagedGameSpaceWorlds(ManagedGameSpace space) {
        this.space = space;
    }

    @Override
    public class_3218 add(RuntimeWorldConfig worldConfig) {
        applyDefaultsTo(worldConfig);

        var worldHandle = Fantasy.get(this.space.getServer()).openTemporaryWorld(worldConfig);
        this.worlds.put(worldHandle.asWorld().method_27983(), worldHandle);

        this.space.onAddWorld(worldHandle);

        return worldHandle.asWorld();
    }

    @Override
    public class_3218 addPersistent(class_2960 identifier, RuntimeWorldConfig worldConfig) {
        var world = this.space.getServer().method_3847(class_5321.method_29179(class_7924.field_41223, identifier));
        if (world != null) {
            throw new RuntimeException("World '" + identifier + "' is already loaded!");
        }

        applyDefaultsTo(worldConfig);

        var worldHandle = Fantasy.get(this.space.getServer()).getOrOpenPersistentWorld(identifier, worldConfig);
        this.worlds.put(worldHandle.asWorld().method_27983(), worldHandle);
        this.space.onAddWorld(worldHandle);

        return worldHandle.asWorld();
    }

    @Override
    public boolean remove(class_3218 world) {
        var dimension = world.method_27983();
        var worldHandle = this.worlds.remove(dimension);
        if (worldHandle != null) {
            this.space.onRemoveWorld(dimension);
            worldHandle.unload();
            return true;
        } else {
            return false;
        }
    }

    void clear() {
        for (var worldHandler : this.worlds.values()) {
            worldHandler.unload();
        }
        this.worlds.clear();
    }

    @NotNull
    @Override
    public Iterator<class_3218> iterator() {
        return Iterators.transform(this.worlds.values().iterator(), RuntimeWorldHandle::asWorld);
    }

    private static void applyDefaultsTo(RuntimeWorldConfig worldConfig) {
        var rules = worldConfig.getGameRules();

        setDefaultRule(rules, class_1928.field_19409, false);
        setDefaultRule(rules, class_1928.field_19396, false);
        setDefaultRule(rules, class_1928.field_19406, false);
        setDefaultRule(rules, class_1928.field_19389, false);
        setDefaultRule(rules, class_1928.field_19390, false);
        setDefaultRule(rules, class_1928.field_59751, false);
    }

    private static <T> void setDefaultRule(GameRuleStore rules, class_12279<T> key, T value) {
        if (!rules.contains(key)) {
            rules.set(key, value);
        }
    }
}
