package xyz.nucleoid.plasmid.impl.player;

import com.mojang.authlib.GameProfile;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.JoinOffer;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public record LocalJoinOffer(Collection<class_3222> serverPlayers, JoinIntent intent) implements JoinOffer {
    @Override
    public Set<GameProfile> players() {
        return this.serverPlayers
                .stream()
                .map(class_1657::method_7334)
                .collect(Collectors.toSet());
    }

    @Override
    public Set<UUID> playerIds() {
        return this.serverPlayers
                .stream()
                .map(player -> player.method_7334().id())
                .collect(Collectors.toSet());
    }

    @Override
    public Set<String> playerNames() {
        return this.serverPlayers
                .stream()
                .map(player -> player.method_7334().name())
                .collect(Collectors.toSet());
    }

    @Override
    public JoinOfferResult.Reject reject(class_2561 reason) {
        return () -> reason;
    }
}
