package xyz.nucleoid.plasmid.impl.player.isolation;

import eu.pb4.polymer.core.api.block.BlockMapper;
import net.minecraft.class_1297;
import net.minecraft.class_2632;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2735;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4543;
import net.minecraft.class_8589;
import net.minecraft.network.packet.s2c.play.*;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.plasmid.api.game.GameSpace;

import java.util.function.Function;

/**
 * Teleports payer in and out of a {@link GameSpace}. This involves ensuring that the player does not bring anything
 * into the game space as well as to not bring anything out of the game space.
 * <p>
 * The player's NBT must be saved on entry to a game space, and it must not be saved when exiting and instead restored.
 * <p>
 * This class is also responsible for resetting player state and sending packets such that the player is fully refreshed
 * after teleporting and no weird issues can arise from invalid state passing through dimensions.
 */
public final class IsolatingPlayerTeleporter {
    private final MinecraftServer server;

    public IsolatingPlayerTeleporter(MinecraftServer server) {
        this.server = server;
    }

    /**
     * Teleports a player into a {@link GameSpace}. The player will save any associated data before teleporting.
     *
     * @param player the player to teleport
     * @param recreate a function describing how the new teleported player should be initialized
     */
    public void teleportIn(class_3222 player, Function<class_3222, class_3218> recreate) {
        this.teleport(player, recreate, true);
    }

    /**
     * Teleports a player out of a {@link GameSpace}. The player will NOT save any associated data before teleporting,
     * and instead will restore any previously saved data.
     *
     * @param player the player to teleport
     * @param recreate a function describing how the new teleported player should be initialized
     */
    public void teleportOut(class_3222 player, Function<class_3222, class_3218> recreate) {
        this.teleport(player, recreate, false);
    }

    /**
     * Teleports a player out of a {@link GameSpace} and into the passed world. The player will NOT save any associated
     * data before teleporting, and instead will restore any previously saved data.
     *
     * @param player the player to teleport
     * @param world the world to teleport to
     */
    public void teleportOutTo(class_3222 player, class_3218 world) {
        this.teleportOut(player, newPlayer -> world);
    }

    /**
     * Teleports a player out of a {@link GameSpace} and into the previous world that they were apart of. The player
     * will NOT save any associated data before teleporting, and instead will restore any previously saved data.
     *
     * @param player the player to teleport
     */
    public void teleportOut(class_3222 player) {
        this.teleportOut(player, class_3222::method_51469);
    }

    private void teleport(class_3222 player, Function<class_3222, class_3218> recreate, boolean in) {
        var playerManager = this.server.method_3760();
        var playerManagerAccess = (PlayerManagerAccess) playerManager;

        player.method_18375();
        player.method_14224(player);

        if (in) {
            playerManagerAccess.plasmid$savePlayerData(player);
        }

        player.method_14236().method_12881();
        this.server.method_3837().method_12976(player);

        player.method_51469().method_18770(player, class_1297.class_5529.field_27002);
        player.method_31482();

        playerManagerAccess.plasmid$getPlayerResetter().apply(player);

        if (!in) {
            playerManagerAccess.plasmid$loadIntoPlayer(player);
        }

        player.method_51469().method_8503().method_3760().method_14581(new class_2703(class_2703.class_5893.field_29137, player));

        var world = recreate.apply(player);
        player.method_51468(world);

        var worldProperties = world.method_8401();

        var spawnInfo = new class_8589(
            world.method_40134(), world.method_27983(),
            class_4543.method_27984(world.method_8412()),
            player.field_13974.method_14257(), player.field_13974.method_30119(),
            world.method_27982(), world.method_28125(), player.method_43122(), player.method_51848(),
            world.method_8615()
        );

        var networkHandler = player.field_13987;
        networkHandler.method_14364(new class_2724(spawnInfo, class_2724.field_41732));

        player.method_7346();

        BlockMapper.resetMapper(player);

        networkHandler.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        networkHandler.method_14372();
        world.method_18769(player);
        networkHandler.method_14364(new class_2632(worldProperties.method_207(), worldProperties.method_197()));
        networkHandler.method_14364(new class_2735(player.method_31548().method_67532()));
        player.method_7355();
        playerManager.method_14576(player);
        player.method_14253().method_14904(player);

        this.server.method_3837().method_12975(player);

        playerManager.method_14606(player, world);
        playerManager.method_14594(player);
        playerManager.method_60598(player);

        // we just sent the full inventory, so we can consider the ScreenHandler as up-to-date
        ((ScreenHandlerAccess) player.field_7498).plasmid$resetTrackedState();
    }
}
