package xyz.nucleoid.plasmid.impl.portal;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.impl.Plasmid;

public interface GamePortalInterface {
    String NBT_KEY = Plasmid.id("portal").toString();

    boolean interactWithPortal(class_3222 player);

    void setPortal(GamePortal portal);

    @Nullable
    GamePortal getPortal();

    void setDisplay(GamePortalDisplay display);

    default void serializePortal(class_11372 root) {
        var connection = this.getPortal();
        if (connection != null) {
            root.method_71469(NBT_KEY, connection.getId().toString());
        }
    }

    @Nullable
    default class_2960 deserializePortalId(class_11368 root) {
        return root.method_71426(NBT_KEY, class_2960.field_25139).orElse(null);
    }

    default boolean tryConnectTo(class_2960 portalId) {
        var portal = GamePortalManager.INSTANCE.byId(portalId);
        if (portal == null) {
            //Plasmid.LOGGER.warn("Loaded channel endpoint with invalid portal id: '{}'", portalId);
            return false;
        }

        portal.addInterface(this);
        return true;
    }

    default void invalidatePortal() {
        var portal = this.getPortal();
        if (portal != null) {
            portal.removeInterface(this);
            this.setPortal(null);
        }
    }

    default boolean updatePortalImmediately() {
        return true;
    };
}
