package xyz.nucleoid.plasmid.impl.portal.menu;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.impl.portal.GamePortalConfig;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;

import java.util.List;

public record AdvancedMenuPortalConfig(
        class_2561 name,
        List<class_2561> description,
        class_1799 icon,
        List<MenuEntryConfig> entries,
        CustomValuesConfig custom
) implements GamePortalConfig {
    public static final MapCodec<AdvancedMenuPortalConfig> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
            PlasmidCodecs.TEXT.optionalFieldOf("name", class_5244.field_39003).forGetter(AdvancedMenuPortalConfig::name),
            MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description", List.of()).forGetter(AdvancedMenuPortalConfig::description),
            MoreCodecs.ITEM_STACK.optionalFieldOf("icon", new class_1799(class_1802.field_8270)).forGetter(AdvancedMenuPortalConfig::icon),
            MenuEntryConfig.CODEC.listOf().fieldOf("entries").forGetter(AdvancedMenuPortalConfig::entries),
            CustomValuesConfig.CODEC.optionalFieldOf("custom", CustomValuesConfig.empty()).forGetter(config -> config.custom)
    ).apply(i, AdvancedMenuPortalConfig::new));

    @Override
    public GamePortalBackend createBackend(MinecraftServer server, class_2960 id) {
        class_2561 name;
        if (this.name != null) {
            name = this.name;
        } else {
            name = class_2561.method_43470(id.toString());
        }

        return new AdvancedMenuPortalBackend(name, description, icon, this.entries);
    }

    @Override
    public MapCodec<AdvancedMenuPortalConfig> codec() {
        return CODEC;
    }
}
