package xyz.nucleoid.plasmid.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nucleoid.plasmid.api.game.GameTypes;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistryKeys;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;

import java.util.Map;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9248;

@Deprecated
@Mixin(class_2370.class)
public abstract class SimpleRegistryMixin {
    @Shadow
    public abstract class_5321<? extends class_2378<Object>> getKey();

    @Shadow
    @Final
    private Map<class_5321<Object>, class_6880.class_6883<Object>> keyToEntry;

    @Shadow
    public abstract class_6880.class_6883<Object> add(class_5321<Object> key, Object value, class_9248 info);

    @Inject(method = "freeze", at = @At("HEAD"))
    private void maybeRegisterInvalidConfigs(CallbackInfoReturnable<class_2378<Object>> cir) {
        if (!PlasmidConfig.get().ignoreInvalidGames() || !this.getKey().equals(PlasmidRegistryKeys.GAME_CONFIG)) {
            return;
        }

        var keys = this.keyToEntry.entrySet().stream().filter((entry) -> !entry.getValue().method_40227()).toList();
        for (var key : keys) {
            Plasmid.LOGGER.error("Something depends on non-existing game config '{}'!", key.getKey().method_29177());
            this.add(key.getKey(), new GameConfig<>(GameTypes.INVALID, null, null, null, null, CustomValuesConfig.empty(), key.getKey().method_29177().toString()), class_9248.field_49136);
        }
    }
}
