package xyz.nucleoid.plasmid.mixin.chat;

import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.stimuli.Stimuli;

@Mixin(value = class_1657.class, priority = 600)
public class PlayerEntityMixin {

    @Inject(method = "getDisplayName", at = @At("TAIL"), cancellable = true)
    private void callDisplayNameEvent(CallbackInfoReturnable<class_2561> cir) {
        if (((Object) this) instanceof class_3222 player) {
            try (var invokers = Stimuli.select().forEntityAt(player, player.method_24515())) {
                class_2561 vanilla = cir.getReturnValue();
                class_2561 output = invokers.get(GamePlayerEvents.DISPLAY_NAME).onDisplayNameCreation(player, vanilla, vanilla);
                if (!vanilla.equals(output)) {
                    cir.setReturnValue(output);
                }
            }
        }
    }
}
