package xyz.nucleoid.plasmid.mixin.game.portal;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalDisplay;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;
import xyz.nucleoid.plasmid.impl.compatibility.DisguiseLibCompatibility;

@Mixin(class_1297.class)
public abstract class EntityMixin implements GamePortalInterface {
    @Shadow
    public class_1937 world;

    @Shadow
    public abstract class_243 getEntityPos();

    @Unique
    private TextDisplayElement textDisplayElement;
    @Unique
    private ElementHolder hologram;
    @Unique
    private GamePortal portal;
    @Unique
    private class_2960 loadedPortalId;

    @Override
    public boolean interactWithPortal(class_3222 player) {
        if (this.portal != null) {
            this.portal.requestJoin(player, false);
            return true;
        }
        return false;
    }

    @Override
    public void setPortal(GamePortal portal) {
        this.portal = portal;
        if (portal == null) {
            this.removeHologram();
        }
    }

    @Nullable
    @Override
    public GamePortal getPortal() {
        return this.portal;
    }

    @Override
    public void setDisplay(GamePortalDisplay display) {
        var hologram = this.getOrCreateTextElement();

        var text = class_2561.method_43473();

        var name = display.get(GamePortalDisplay.NAME);
        var playerCount = display.get(GamePortalDisplay.PLAYER_COUNT);
        if (name != null && playerCount != null) {
            text.method_10852(name);
            if (playerCount > -1) {
                text.method_27693("\n").method_10852(class_2561.method_43469("text.plasmid.game.portal.player_count", playerCount));
            }
        }
        hologram.setText(text);

        if (hologram.isDirty()) {
            hologram.tick();
        }
    }

    @Unique
    private TextDisplayElement getOrCreateTextElement() {
        if (this.hologram != null) {
            return textDisplayElement;
        }

        var entity = (class_1297) (Object) this;
        var offset = new class_243(0.0, DisguiseLibCompatibility.getEntityHeight(entity) + 0.2, 0.0);

        this.hologram = new ElementHolder();
        this.textDisplayElement = new TextDisplayElement();
        this.textDisplayElement.setOffset(offset);
        this.textDisplayElement.setBrightness(new class_8104(15, 15));
        this.textDisplayElement.setBillboardMode(class_8113.class_8114.field_42409);
        this.textDisplayElement.setDisplayWidth(5);
        this.textDisplayElement.setDisplayHeight(1);
        this.textDisplayElement.setViewRange(0.5f);
        this.hologram.addElement(this.textDisplayElement);

        EntityAttachment.of(this.hologram, (class_1297) (Object) this);

        return this.textDisplayElement;
    }

    private void removeHologram() {
        var hologram = this.hologram;
        this.hologram = null;

        if (hologram != null) {
            hologram.destroy();
            this.textDisplayElement = null;
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void onTick(CallbackInfo ci) {
        if (this.loadedPortalId != null) {
            if (this.tryConnectTo(this.loadedPortalId)) {
                this.loadedPortalId = null;
            }
        }
    }

    @Inject(method = "writeData", at = @At("RETURN"))
    private void writePortalData(class_11372 view, CallbackInfo ci) {
        if (this.loadedPortalId == null) {
            this.serializePortal(view);
        } else {
            view.method_71469(GamePortalInterface.NBT_KEY, this.loadedPortalId.toString());
        }
    }

    @Inject(method = "readData", at = @At("RETURN"))
    private void readPortalData(class_11368 view, CallbackInfo ci) {
        this.loadedPortalId = this.deserializePortalId(view);
    }

    @Inject(method = "remove", at = @At("HEAD"))
    private void remove(CallbackInfo ci) {
        this.invalidatePortal();
        this.removeHologram();
    }
}
