package xyz.nucleoid.plasmid.mixin.game.rule;

import net.minecraft.class_1937;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2700;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.stimuli.event.EventResult;

@Mixin(class_2700.class)
public class BlockPatternMixin {
    @Inject(
            method = "searchAround",
            at = @At("HEAD")
    )
    private void applyPortalsRuleToEndPortals(class_4538 worldView, class_2338 pos, CallbackInfoReturnable<class_2700.class_2702> ci) {
        if (!(worldView instanceof class_1937 world) || ((class_2700) (Object) this) != class_2333.method_10054()) {
            return;
        }

        var gameSpace = GameSpaceManagerImpl.get().byWorld(world);
        if (gameSpace != null && gameSpace.getBehavior().testRule(GameRuleType.PORTALS) == EventResult.DENY) {
            ci.setReturnValue(null);
        }
    }
}
