package xyz.nucleoid.plasmid.mixin.game.rule;

import net.minecraft.class_1723;
import net.minecraft.class_2535;
import net.minecraft.class_2653;
import net.minecraft.class_2813;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.class_9834;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.stimuli.event.EventResult;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin extends class_8609 {
    @Shadow
    public class_3222 player;

    public ServerPlayNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Inject(
            method = "onClickSlot",
            cancellable = true,
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V",
                    shift = At.Shift.AFTER
            )
    )
    private void onClickSlot(class_2813 packet, CallbackInfo ci) {
        var gameSpace = GameSpaceManagerImpl.get().byPlayer(this.player);

        if (gameSpace != null) {
            if (packet.comp_3844() < 0 || packet.comp_3844() >= this.player.method_31548().method_5439()) return;
            // See https://wiki.vg/File:Inventory-slots.png for the slot numbering
            var screenHandler = this.player.field_7512;

            boolean isArmor = (packet.comp_3844() >= 5 && packet.comp_3844() <= 8) && screenHandler instanceof class_1723;
            boolean denyModifyInventory = gameSpace.getBehavior().testRule(GameRuleType.MODIFY_INVENTORY) == EventResult.DENY;
            var modifyArmor = gameSpace.getBehavior().testRule(GameRuleType.MODIFY_ARMOR);
            if ((denyModifyInventory && (!isArmor || modifyArmor != EventResult.ALLOW))
                    || (isArmor && modifyArmor == EventResult.DENY)) {
                var stack = screenHandler.method_7611(packet.comp_3844()).method_7677();

                this.method_14364(new class_2653(packet.comp_3842(), screenHandler.method_37422(), packet.comp_3844(), stack));
                this.method_14364(new class_9834(screenHandler.method_34255()));

                ci.cancel();
            }
        }
    }
}
