package xyz.nucleoid.plasmid.mixin.game.space;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_29;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3442;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_8791;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.player.isolation.PlayerManagerAccess;
import xyz.nucleoid.plasmid.impl.player.isolation.PlayerResetter;

import java.util.List;
import java.util.Map;
import java.util.UUID;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin implements PlayerManagerAccess {
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private class_29 saveHandler;
    @Shadow
    @Final
    private Map<UUID, class_3442> statisticsMap;
    @Shadow
    @Final
    private Map<UUID, class_2985> advancementTrackers;

    @Shadow
    protected abstract void savePlayerData(class_3222 player);

    @Shadow
    public abstract class_2487 getUserData();

    @Shadow @Final private static Logger LOGGER;
    @Shadow @Final private List<class_3222> players;
    @Shadow @Final private Map<UUID, class_3222> playerMap;

    @Shadow public abstract MinecraftServer getServer();

    @Unique
    private PlayerResetter playerResetter;

    @Inject(method = "remove", at = @At("RETURN"))
    private void removePlayer(class_3222 player, CallbackInfo ci) {
        var gameSpace = GameSpaceManagerImpl.get().byPlayer(player);
        if (gameSpace != null) {
            gameSpace.getPlayers().remove(player);
        }
    }

    @Inject(
            method = "respawnPlayer",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/network/ServerPlayerEntity;copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V",
                    shift = At.Shift.AFTER
            ),
            locals = LocalCapture.CAPTURE_FAILHARD
    )
    private void respawnPlayer(
            class_3222 oldPlayer, boolean alive, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> ci,
            class_5454 respawnTarget, class_3218 respawnWorld, class_3222 respawnedPlayer
    ) {
        var gameSpace = GameSpaceManagerImpl.get().byPlayer(oldPlayer);

        if (gameSpace != null) {
            gameSpace.getPlayers().remove(oldPlayer);

            this.plasmid$loadIntoPlayer(respawnedPlayer);
            respawnedPlayer.method_51468(respawnWorld);

            // this is later used to apply back to the respawned player, and we want to maintain that
            var interactionManager = respawnedPlayer.field_13974;
            oldPlayer.field_13974.method_14261(interactionManager.method_14257(), interactionManager.method_30119());

            respawnedPlayer.method_14213(oldPlayer.method_53823());
        }
    }

    @Override
    public void plasmid$savePlayerData(class_3222 player) {
        this.savePlayerData(player);
    }

    @Override
    public void plasmid$loadIntoPlayer(class_3222 player) {
        var userData = this.getUserData();
        if (userData == null) {
            userData = this.server.method_27728().method_226();
        }

        class_11368 playerData;
        if (this.server.method_19466(player.method_72498()) && userData != null) {
            playerData = class_11352.method_71417(class_8942.field_60348, player.method_56673(), userData);
            player.method_5651(playerData);
        } else {
            playerData = this.saveHandler.method_55789(player.method_72498())
                    .map(compound -> class_11352.method_71417(class_8942.field_60348, player.method_56673(), compound))
                    .orElse(null);
        }

        if (playerData != null) {
            player.method_5651(playerData);
        }

        var dimension = playerData != null ? this.getDimensionFromData(playerData) : null;

        var world = this.server.method_3847(dimension);
        if (world == null) {
            world = this.server.method_30002();
        }

        player.method_51468(world);
    }

    @Unique
    private class_5321<class_1937> getDimensionFromData(class_11368 view) {
        return view.method_71426("Dimension", class_1937.field_25178).orElse(class_1937.field_25179);
    }

    @WrapWithCondition(
            method = "savePlayerData",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/PlayerSaveHandler;savePlayerData(Lnet/minecraft/entity/player/PlayerEntity;)V")
    )
    private boolean savePlayerData(class_29 handler, class_1657 player) {
        return !GameSpaceManagerImpl.get().inGame(player);
    }

    @Override
    public PlayerResetter plasmid$getPlayerResetter() {
        if (this.playerResetter == null) {
            var overworld = this.server.method_30002();
            var profile = new GameProfile(class_156.field_25140, "null");

            var player = new class_3222(this.server, overworld, profile, class_8791.method_53821());
            this.statisticsMap.remove(class_156.field_25140);
            this.advancementTrackers.remove(class_156.field_25140);

            var tag = class_11362.method_71459(class_8942.field_60348, this.getServer().method_30611());
            player.method_5647(tag);
            tag.method_71478("UUID");
            tag.method_71478("Pos");

            this.playerResetter = new PlayerResetter(tag.method_71475());
        }

        return this.playerResetter;
    }
}
