/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.impl.game.manager.ManagedGameActivity;

public final class GameLifecycle {
    private final List<Listeners> listeners = new ArrayList<Listeners>();

    public void addListeners(Listeners listeners) {
        this.listeners.add(listeners);
    }

    public void onAddPlayer(GameSpace gameSpace, class_3222 player) {
        for (Listeners listener : this.listeners) {
            listener.onAddPlayer(gameSpace, player);
        }
    }

    public void onRemovePlayer(GameSpace gameSpace, class_3222 player) {
        for (Listeners listener : this.listeners) {
            listener.onRemovePlayer(gameSpace, player);
        }
    }

    public void onClosing(GameSpace gameSpace, GameCloseReason reason) {
        for (Listeners listener : this.listeners) {
            listener.onClosing(gameSpace, reason);
        }
    }

    public void onClosed(GameSpace gameSpace, List<class_3222> players, GameCloseReason reason) {
        for (Listeners listener : this.listeners) {
            listener.onClosed(gameSpace, players, reason);
        }
    }

    public void onError(GameSpace gameSpace, Throwable throwable, String context) {
        for (Listeners listener : this.listeners) {
            listener.onError(gameSpace, throwable, context);
        }
    }

    public void beforeActivityChange(GameSpace gameSpace, GameActivity activity, @Nullable GameActivity closedActivity) {
        for (Listeners listener : this.listeners) {
            listener.beforeActivityChange(gameSpace, activity, closedActivity);
        }
    }

    public void afterActivityChange(GameSpace gameSpace, ManagedGameActivity activity, @Nullable ManagedGameActivity closedActivity) {
        for (Listeners listener : this.listeners) {
            listener.afterActivityChange(gameSpace, activity, closedActivity);
        }
    }

    public static interface Listeners {
        default public void onAddPlayer(GameSpace gameSpace, class_3222 player) {
        }

        default public void onRemovePlayer(GameSpace gameSpace, class_3222 player) {
        }

        default public void onClosing(GameSpace gameSpace, GameCloseReason reason) {
        }

        default public void onClosed(GameSpace gameSpace, List<class_3222> players, GameCloseReason reason) {
        }

        default public void onError(GameSpace gameSpace, Throwable throwable, String context) {
        }

        default public void beforeActivityChange(GameSpace gameSpace, GameActivity activity, @Nullable GameActivity closedActivity) {
        }

        default public void afterActivityChange(GameSpace gameSpace, GameActivity activity, @Nullable GameActivity closedActivity) {
        }
    }
}

