/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common;

import com.google.common.hash.Hashing;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9053;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.PlasmidWebServer;

public final class GameResourcePack {
    private static final Path RESOURCE_PACKS_ROOT = FabricLoader.getInstance().getGameDir().resolve("plasmid-generated/resource-packs");
    private final UUID uuid;
    private final String url;
    private final String hash;
    private boolean required;
    private class_2561 prompt;
    private boolean isLocal;

    public GameResourcePack(String url, String hash) {
        this.url = url;
        this.uuid = UUID.nameUUIDFromBytes(hash.getBytes());
        this.hash = hash;
        this.isLocal = false;
    }

    public GameResourcePack(UUID uuid, String url, String hash) {
        this.url = url;
        this.uuid = uuid;
        this.hash = hash;
        this.isLocal = false;
    }

    private GameResourcePack(UUID uuid, String url, String hash, Void unused) {
        this.url = url;
        this.uuid = uuid;
        this.hash = hash;
        this.isLocal = true;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public GameResourcePack setRequired() {
        this.required = true;
        return this;
    }

    public GameResourcePack setPrompt(class_2561 prompt) {
        this.prompt = prompt;
        return this;
    }

    public void addTo(GameActivity activity) {
        activity.listen(GamePlayerEvents.ADD, this::sendTo);
        activity.listen(GamePlayerEvents.REMOVE, this::unload);
    }

    private void sendTo(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2720(this.uuid, this.url, this.hash, this.required, Optional.ofNullable(this.prompt)));
    }

    private void unload(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_9053(Optional.of(this.uuid)));
    }

    public static Optional<GameResourcePack> from(class_2960 identifier, ResourcePackCreator creator) {
        try {
            String relative = identifier.method_12836() + "/" + identifier.method_12832() + ".zip";
            Path path = RESOURCE_PACKS_ROOT.resolve(relative);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            creator.build(path);
            String hash = com.google.common.io.Files.asByteSource((File)path.toFile()).hash(Hashing.sha1()).toString();
            String url = PlasmidWebServer.registerResourcePack(relative, path);
            return Optional.of(new GameResourcePack(UUID.nameUUIDFromBytes(hash.getBytes(StandardCharsets.UTF_8)), url, hash, null));
        }
        catch (Throwable e) {
            Plasmid.LOGGER.error("Failed to create a resource pack '" + String.valueOf(identifier) + "'!", e);
            return Optional.empty();
        }
    }
}

