/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.common.widget.BossBarWidget;
import xyz.nucleoid.plasmid.api.game.common.widget.GameWidget;
import xyz.nucleoid.plasmid.api.game.common.widget.ScrollableSidebarWidget;
import xyz.nucleoid.plasmid.api.game.common.widget.SidebarWidget;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;

public final class GlobalWidgets
implements AutoCloseable {
    private final GameSpace gameSpace;
    private final List<GameWidget> widgets = new ArrayList<GameWidget>();

    private GlobalWidgets(GameSpace gameSpace) {
        this.gameSpace = gameSpace;
    }

    public static GlobalWidgets addTo(GameActivity activity) {
        GlobalWidgets widgets = new GlobalWidgets(activity.getGameSpace());
        activity.listen(GamePlayerEvents.ADD, widgets::onAddPlayer);
        activity.listen(GamePlayerEvents.REMOVE, widgets::onRemovePlayer);
        activity.listen(GameActivityEvents.DISABLE, widgets::close);
        return widgets;
    }

    public SidebarWidget addSidebar(class_2561 title) {
        return this.addWidget(new SidebarWidget(title));
    }

    public SidebarWidget addSidebar() {
        return this.addWidget(new SidebarWidget());
    }

    public SidebarWidget addSidebar(class_2561 title, Predicate<class_3222> playerChecker) {
        return this.addWidget(new SidebarWidget(title, playerChecker));
    }

    public SidebarWidget addSidebar(Predicate<class_3222> playerChecker) {
        return this.addWidget(new SidebarWidget(playerChecker));
    }

    public ScrollableSidebarWidget addScrollableSidebar(class_2561 title, int ticksPerLine) {
        return this.addWidget(new ScrollableSidebarWidget(title, ticksPerLine));
    }

    public ScrollableSidebarWidget addScrollableSidebar(int ticksPerLine) {
        return this.addWidget(new ScrollableSidebarWidget(ticksPerLine));
    }

    public ScrollableSidebarWidget addScrollableSidebar(class_2561 title, int ticksPerLine, Predicate<class_3222> playerChecker) {
        return this.addWidget(new ScrollableSidebarWidget(title, ticksPerLine, playerChecker));
    }

    public ScrollableSidebarWidget addScrollableSidebar(int ticksPerLine, Predicate<class_3222> playerChecker) {
        return this.addWidget(new ScrollableSidebarWidget(ticksPerLine, playerChecker));
    }

    public BossBarWidget addBossBar(class_2561 title) {
        return this.addWidget(new BossBarWidget(title));
    }

    public BossBarWidget addBossBar(class_2561 title, class_1259.class_1260 color, class_1259.class_1261 style) {
        return this.addWidget(new BossBarWidget(title, color, style));
    }

    public <T extends GameWidget> T addWidget(T widget) {
        for (class_3222 player : this.gameSpace.getPlayers()) {
            widget.addPlayer(player);
        }
        this.widgets.add(widget);
        return widget;
    }

    public void removeWidget(GameWidget widget) {
        if (this.widgets.remove(widget)) {
            widget.close();
        }
    }

    private void onAddPlayer(class_3222 player) {
        for (GameWidget widget : this.widgets) {
            widget.addPlayer(player);
        }
    }

    private void onRemovePlayer(class_3222 player) {
        for (GameWidget widget : this.widgets) {
            widget.removePlayer(player);
        }
    }

    @Override
    public void close() {
        for (GameWidget widget : this.widgets) {
            widget.close();
        }
        this.widgets.clear();
    }
}

