/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TeamAllocator<T, V> {
    private static final Comparator<Set<?>> LARGEST_SET_FIRST_COMPARATOR = Comparator.comparingInt(Set::size).reversed();
    private final List<T> teams;
    private final List<V> players = new ArrayList<V>();
    private final Map<V, T> teamPreferences = new Object2ObjectOpenHashMap();
    private final Set<V> groupedPlayers = new HashSet<V>();
    private final Set<Set<V>> groupPreferences = new HashSet<Set<V>>();
    private final Object2IntMap<T> teamSizes = new Object2IntOpenHashMap();

    public TeamAllocator(Collection<T> teams) {
        Preconditions.checkArgument((!teams.isEmpty() ? 1 : 0) != 0, (Object)"cannot allocate with no teams");
        this.teams = new ArrayList<T>(teams);
        this.teamSizes.defaultReturnValue(Integer.MAX_VALUE);
    }

    public void setSizeForTeam(T team, int maxSize) {
        Preconditions.checkArgument((boolean)this.teams.contains(team), (Object)("invalid team: " + String.valueOf(team)));
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"max team size must be >0");
        this.teamSizes.put(team, maxSize);
    }

    public void add(V player, @Nullable T preference) {
        this.players.add(player);
        if (preference != null) {
            this.teamPreferences.put(player, preference);
        }
    }

    @ApiStatus.Experimental
    public void group(Iterable<V> group) {
        for (V player : group) {
            if (!this.players.contains(player)) {
                throw new IllegalArgumentException("cannot group unadded player " + String.valueOf(player));
            }
            if (!this.groupedPlayers.contains(player)) continue;
            throw new IllegalStateException("player " + String.valueOf(player) + " is already in a group");
        }
        this.groupPreferences.add(Sets.newHashSet(group));
        group.forEach(this.groupedPlayers::add);
    }

    public void allocate(BiConsumer<T, V> apply) {
        Multimap<T, V> teamToPlayers = this.allocate();
        teamToPlayers.forEach(apply);
    }

    public Multimap<T, V> allocate() {
        Allocations<T, V> allocations = new Allocations<T, V>(this.teamPreferences);
        this.placePlayersRandomly(allocations);
        this.setGroupPreferences(allocations);
        this.optimizeTeamsByPreference(allocations);
        return allocations.teamToPlayers;
    }

    private void placePlayersRandomly(Allocations<T, V> allocations) {
        ArrayList<T> availableTeams = new ArrayList<T>(this.teams);
        ArrayList<V> players = new ArrayList<V>(this.players);
        Collections.shuffle(availableTeams);
        Collections.shuffle(players);
        int teamIndex = 0;
        for (V player : players) {
            if (availableTeams.isEmpty()) {
                throw new IllegalStateException("team overflow! all teams have exceeded maximum capacity");
            }
            T team = availableTeams.get(teamIndex);
            allocations.setTeam(player, team);
            int maxTeamSize = this.teamSizes.getInt(team);
            if (allocations.playersIn(team).size() >= maxTeamSize) {
                availableTeams.remove(teamIndex);
            }
            teamIndex = (teamIndex + 1) % availableTeams.size();
        }
    }

    private void setGroupPreferences(Allocations<T, V> allocations) {
        ArrayList<Set<V>> groupPreferences = new ArrayList<Set<V>>(this.groupPreferences);
        ArrayList<T> teams = new ArrayList<T>(this.teams);
        Collections.shuffle(groupPreferences);
        Collections.shuffle(teams);
        groupPreferences.sort(LARGEST_SET_FIRST_COMPARATOR);
        teams.sort(Comparator.comparingInt(team -> this.teamSizes.getInt(team)).reversed());
        int teamIndex = 0;
        for (Set<V> group : groupPreferences) {
            T team2 = teams.get(teamIndex);
            for (V player : group) {
                allocations.teamPreferences.putIfAbsent(player, team2);
            }
            teamIndex = (teamIndex + 1) % this.teams.size();
        }
    }

    private void optimizeTeamsByPreference(Allocations<T, V> allocations) {
        ArrayList<V> players = new ArrayList<V>(this.players);
        Collections.shuffle(players);
        for (V player : players) {
            Object preference = allocations.teamPreferences.get(player);
            T current = allocations.teamFor(player);
            if (preference == null || current == preference) continue;
            Collection<V> currentPlayers = allocations.playersIn(current);
            Collection<V> preferencePlayers = allocations.playersIn(preference);
            if (preferencePlayers.size() < currentPlayers.size() && this.canTeamGrow(preference, preferencePlayers.size())) {
                allocations.moveTeam(player, current, preference);
                continue;
            }
            this.trySwapWithOtherPlayer(allocations, player, current, preference);
        }
    }

    private boolean canTeamGrow(T team, int size) {
        int maxSize = this.teamSizes.getInt(team);
        return size < maxSize;
    }

    private void trySwapWithOtherPlayer(Allocations<T, V> allocations, V player, T from, T to) {
        V swapWith = this.findSwapCandidate(allocations, from, to, allocations.playersIn(to));
        if (swapWith != null) {
            allocations.moveTeam(player, from, to);
            allocations.moveTeam(swapWith, to, from);
        }
    }

    @Nullable
    private V findSwapCandidate(Allocations<T, V> allocations, T from, T to, Collection<V> candidates) {
        V swapWith = null;
        for (V candidate : candidates) {
            Object candidatePreference = allocations.teamPreferences.get(candidate);
            if (candidatePreference == to || swapWith != null && candidatePreference != from) continue;
            swapWith = candidate;
        }
        return swapWith;
    }

    static final class Allocations<T, V> {
        final Multimap<T, V> teamToPlayers = HashMultimap.create();
        final Map<V, T> playerToTeam = new Object2ObjectOpenHashMap();
        final Map<V, T> teamPreferences = new Object2ObjectOpenHashMap();

        Allocations(Map<V, T> teamPreferences) {
            this.teamPreferences.putAll(teamPreferences);
        }

        void setTeam(V player, T team) {
            this.teamToPlayers.put(team, player);
            this.playerToTeam.put(player, team);
        }

        T teamFor(V player) {
            return this.playerToTeam.get(player);
        }

        Collection<V> playersIn(T team) {
            return this.teamToPlayers.get(team);
        }

        void moveTeam(V player, T from, T to) {
            this.teamToPlayers.remove(from, player);
            this.teamToPlayers.put(to, player);
            this.playerToTeam.put(player, to);
        }
    }
}

