/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team;

import net.minecraft.class_1297;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import xyz.nucleoid.plasmid.api.chat.ChatChannel;
import xyz.nucleoid.plasmid.api.chat.HasChatChannel;
import xyz.nucleoid.plasmid.api.chat.PlasmidMessageTypes;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.TeamManager;
import xyz.nucleoid.stimuli.event.player.ReplacePlayerChatEvent;

public final class TeamChat {
    private final TeamManager manager;

    private TeamChat(TeamManager manager) {
        this.manager = manager;
    }

    public static void addTo(GameActivity activity, TeamManager manager) {
        TeamChat teamChat = new TeamChat(manager);
        activity.listen(ReplacePlayerChatEvent.EVENT, teamChat::onSendMessage);
    }

    private boolean onSendMessage(class_3222 player, class_7471 message, class_2556.class_7602 messageType) {
        HasChatChannel hasChannel;
        GameTeamKey team = this.manager.teamFor(player);
        if (team != null && player instanceof HasChatChannel && (hasChannel = (HasChatChannel)player).getChatChannel() == ChatChannel.TEAM) {
            class_2561 teamName = this.manager.getTeamConfig(team).name();
            class_2556.class_7602 teamMessageType = class_2556.method_44832(PlasmidMessageTypes.TEAM_CHAT, (class_1297)player).method_44839(teamName);
            class_7604 sentMessage = class_7604.method_44857((class_7471)message);
            for (class_3222 receiver : this.manager.playersIn(team)) {
                receiver.method_43505(sentMessage, player.method_33795(receiver), teamMessageType);
            }
            return true;
        }
        return false;
    }
}

